<?php $__env->startSection('content'); ?>


<div class="dashboard-hero animate-slide-up" style="background: linear-gradient(135deg, #0f766e 0%, #115e59 50%, #134e4a 100%);">
    <div class="hero-content">
        <div class="hero-greeting">المالية 💰</div>
        <h1 class="hero-title">دليل الحسابات</h1>
        <p class="hero-subtitle">إدارة شجرة الحسابات والهيكل المالي للمنظمة</p>
        <div class="hero-actions d-flex gap-2">
            <a href="<?php echo e(route('accounts.create')); ?>" class="btn btn-sm rounded-pill px-4">
                <i class="bi bi-plus-lg me-1"></i> إضافة حساب
            </a>
        </div>
    </div>
    <i class="bi bi-journal-text hero-icon d-none d-md-block"></i>
</div>

<div class="chart-container animate-slide-up animate-delay-1 mb-4">
    <div class="table-responsive">
        <table class="table table-hover align-middle mb-0">
        <thead class="bg-transparent">
            <tr>
                <th>الكود</th>
                <th>الاسم</th>
                <th>النوع</th>
                <th>الحساب الرئيسي</th>
                <th>الوصف</th>
                <th>إجراءات</th>
            </tr>
        </thead>
        <tbody>
            <?php $__currentLoopData = $allAccounts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $account): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <tr>
                <td><?php echo e($account->code); ?></td>
                <td><?php echo e($account->name); ?></td>
                <td>
                    <?php switch($account->type):
                        case ('asset'): ?> أصول <?php break; ?>
                        <?php case ('liability'): ?> خصوم <?php break; ?>
                        <?php case ('equity'): ?> حقوق ملكية <?php break; ?>
                        <?php case ('revenue'): ?> إيرادات <?php break; ?>
                        <?php case ('expense'): ?> مصروفات <?php break; ?>
                        <?php default: ?> <?php echo e($account->type); ?>

                    <?php endswitch; ?>
                </td>
                <td><?php echo e(optional($account->parent)->name); ?></td>
                <td><?php echo e(Str::limit($account->description, 50)); ?></td>
                <td>
                    <a href="<?php echo e(route('accounts.show', $account)); ?>" class="btn btn-sm btn-outline-info">كشف حساب</a>
                    <?php if(auth()->check()): ?>
                        <?php if(auth()->user()->hasRole('admin') || auth()->user()->hasRole('manager')): ?>
                            <a href="<?php echo e(route('accounts.edit', $account)); ?>" class="btn btn-sm btn-outline-primary">تعديل</a>
                            <form action="<?php echo e(route('accounts.destroy', $account)); ?>" method="POST" class="d-inline" onsubmit="return confirm('هل أنت متأكد من حذف هذا الحساب نهائياً؟')">
                                <?php echo csrf_field(); ?> <?php echo method_field('DELETE'); ?>
                                <button class="btn btn-sm btn-outline-danger">حذف</button>
                            </form>
                        <?php else: ?>
                            <a href="<?php echo e(route('accounts.edit', $account)); ?>" class="btn btn-sm btn-outline-warning">طلب تعديل</a>
                            <form action="<?php echo e(route('accounts.destroy', $account)); ?>" method="POST" class="d-inline" onsubmit="return confirm('هل أنت متأكد من طلب حذف هذا الحساب؟')">
                                <?php echo csrf_field(); ?> <?php echo method_field('DELETE'); ?>
                                <button class="btn btn-sm btn-outline-warning">طلب حذف</button>
                            </form>
                        <?php endif; ?>
                    <?php endif; ?>
                </td>
            </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tbody>
    </table>
    </div>
    <?php echo e($allAccounts->links()); ?>

</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\Users\HP\Downloads\ensan\System.Ensan-main\System.Ensan-main\resources\views/accounts/index.blade.php ENDPATH**/ ?>