<?php $__env->startSection('content'); ?>

<div class="dashboard-hero animate-slide-up" style="background: linear-gradient(135deg, #6366f1 0%, #4f46e5 50%, #4338ca 100%);">
    <div class="hero-content">
        <div class="hero-greeting">الموارد البشرية 👥</div>
        <h1 class="hero-title">الموظفين والمستخدمين</h1>
        <p class="hero-subtitle">إدارة حسابات النظام والموارد البشرية</p>
        <div class="hero-actions d-flex gap-2">
            <a href="<?php echo e(route('users.create')); ?>" class="btn btn-sm rounded-pill px-4">
                <i class="bi bi-plus-lg me-1"></i> إضافة مستخدم
            </a>
        </div>
    </div>
    <i class="bi bi-people-fill hero-icon d-none d-md-block"></i>
</div>


<?php if(request()->anyFilled(['active', 'project_id', 'type'])): ?>
    <div class="animate-slide-up mb-3">
        <a href="<?php echo e(route('users.index')); ?>" class="btn btn-sm btn-light border rounded-pill px-3">
            <i class="bi bi-x-lg me-1"></i> عرض الكل (مسح الفلتر)
        </a>
    </div>
<?php endif; ?>


<div class="row g-3 mb-4">
    <div class="col-md-3 animate-slide-up animate-delay-1">
        <a href="<?php echo e(route('users.index', ['type' => 'employee'])); ?>" class="stat-card stat-primary text-decoration-none">
            <div class="stat-icon"><i class="bi bi-people-fill"></i></div>
            <div class="stat-label">إجمالي الموظفين</div>
            <div class="stat-value"><?php echo e(number_format($totalEmployees)); ?></div>
            <i class="bi bi-people-fill stat-bg-icon"></i>
        </a>
    </div>
    <div class="col-md-3 animate-slide-up animate-delay-2">
        <a href="<?php echo e(route('users.index', ['type' => 'employee', 'active' => '1'])); ?>" class="stat-card stat-success text-decoration-none">
            <div class="stat-icon"><i class="bi bi-check-circle-fill"></i></div>
            <div class="stat-label">الموظفين النشطين</div>
            <div class="stat-value"><?php echo e(number_format($activeEmployees)); ?></div>
            <div class="stat-trend up"><i class="bi bi-check"></i> نشط</div>
            <i class="bi bi-check-circle-fill stat-bg-icon"></i>
        </a>
    </div>
    <div class="col-md-6 animate-slide-up animate-delay-3">
        <div class="summary-panel h-100">
            <h5 class="summary-title"><i class="bi bi-briefcase text-primary"></i> الموظفين حسب المشروع</h5>
            <div class="d-flex flex-wrap gap-2">
                <?php $__currentLoopData = $projectsWithStats; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $p): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <?php if($p->employees_count > 0): ?>
                        <a href="<?php echo e(route('users.index', ['type' => 'employee', 'project_id' => $p->id])); ?>" class="badge bg-primary-subtle text-primary border border-primary-subtle px-3 py-2 text-decoration-none hover-lift">
                            <?php echo e($p->name); ?>: <span class="fw-bold"><?php echo e($p->employees_count); ?></span>
                        </a>
                    <?php endif; ?>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                <?php if($projectsWithStats->sum('employees_count') == 0): ?>
                    <small class="text-muted">لا يوجد موظفين معينين لمشاريع بعد.</small>
                <?php endif; ?>
            </div>
        </div>
    </div>
</div>

    <!-- Users Cards Grid -->
    <div class="row g-3">
        <?php $__currentLoopData = $users; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $u): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <div class="col-md-4 col-sm-6">
                <div class="card h-100 shadow-sm border-0">
                    <div class="card-body position-relative">
                        <div class="d-flex justify-content-between align-items-start mb-2">
                            <h5 class="card-title fw-bold text-body mb-0 text-truncate" style="max-width: 70%;"><?php echo e($u->name); ?>

                            </h5>
                            <?php if($u->active): ?>
                                <span class="badge bg-success-subtle text-success rounded-pill">نشط</span>
                            <?php else: ?>
                                <span class="badge bg-secondary-subtle text-secondary rounded-pill">غير نشط</span>
                            <?php endif; ?>
                        </div>

                        <div class="text-muted small mb-2">
                            <i class="bi bi-person-badge me-1"></i> <?php echo e($u->job_title ?? 'غير محدد'); ?>

                        </div>
                        <div class="text-muted small mb-2">
                            <i class="bi bi-building me-1"></i> <?php echo e($u->department ?? 'غير محدد'); ?>

                        </div>
                        <div class="text-muted small mb-3">
                            <i class="bi bi-envelope me-1"></i> <?php echo e($u->email); ?>

                        </div>

                        <div class="mb-1">
                            <?php if($u->project): ?>
                                <span class="badge bg-primary-subtle text-primary border border-primary-subtle"><i
                                        class="bi bi-briefcase me-1"></i> <?php echo e($u->project->name); ?></span>
                            <?php elseif($u->campaign): ?>
                                <span class="badge bg-warning-subtle text-warning border border-warning-subtle"><i
                                        class="bi bi-megaphone me-1"></i> <?php echo e($u->campaign->name); ?></span>
                            <?php elseif($u->guestHouse): ?>
                                <span class="badge bg-info-subtle text-info border border-info-subtle"><i
                                        class="bi bi-house me-1"></i> <?php echo e($u->guestHouse->name); ?></span>
                            <?php else: ?>
                                <span class="badge bg-secondary-subtle text-secondary border">غير معين</span>
                            <?php endif; ?>
                        </div>

                        <!-- Roles -->
                        <?php if($u->roles->count() > 0): ?>
                            <div class="mt-2">
                                <?php $__currentLoopData = $u->roles; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $role): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <span class="badge bg-secondary-subtle text-secondary"
                                        style="font-size: 0.75rem;"><?php echo e($role->name); ?></span>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </div>
                        <?php endif; ?>

                        <a href="<?php echo e(route('users.show', $u)); ?>" class="stretched-link"></a>
                    </div>

                    <div class="card-footer bg-transparent border-top-0 d-flex justify-content-end py-2"
                        style="position: relative; z-index: 2;">
                        <?php $currentUser = request()->user(); ?>
                        <?php if($currentUser): ?>
                            <?php if($u->pendingRequest): ?>
                                <span class="badge bg-warning bg-opacity-10 text-warning d-flex align-items-center px-3 py-1 rounded-pill small">
                                    <i class="bi bi-hourglass-split me-1"></i> قيد المراجعة
                                </span>
                            <?php else: ?>
                                <?php if($currentUser->hasRole('admin') || $currentUser->hasRole('manager') || $currentUser->hasRole('finance')): ?>
                                    <a href="<?php echo e(route('users.edit', $u)); ?>" class="btn btn-sm btn-outline-secondary me-1" title="تعديل"><i
                                            class="bi bi-pencil"></i></a>
                                    <form class="d-inline" method="POST" action="<?php echo e(route('users.destroy', $u)); ?>"
                                        onsubmit="return confirm('هل أنت متأكد من حذف هذا المستخدم نهائياً؟');">
                                        <?php echo csrf_field(); ?> <?php echo method_field('DELETE'); ?>
                                        <button class="btn btn-sm btn-outline-danger" title="حذف"><i class="bi bi-trash"></i></button>
                                    </form>
                                <?php else: ?>
                                    <a href="<?php echo e(route('users.edit', $u)); ?>" class="btn btn-sm btn-outline-warning me-1" title="طلب تعديل"><i
                                            class="bi bi-pencil-square"></i></a>
                                    <form class="d-inline" method="POST" action="<?php echo e(route('users.destroy', $u)); ?>"
                                        onsubmit="return confirm('هل أنت متأكد من طلب حذف هذا المستخدم؟');">
                                        <?php echo csrf_field(); ?> <?php echo method_field('DELETE'); ?>
                                        <button class="btn btn-sm btn-outline-warning" title="طلب حذف"><i class="bi bi-x-circle"></i></button>
                                    </form>
                                <?php endif; ?>
                            <?php endif; ?>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </div>

    <div class="mt-4"><?php echo e($users->links()); ?></div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\Users\HP\Downloads\ensan\System.Ensan-main\System.Ensan-main\resources\views/users/index.blade.php ENDPATH**/ ?>