<?php $__env->startSection('content'); ?>

    
    <div class="dashboard-hero animate-slide-up" style="background: linear-gradient(135deg, #475569 0%, #334155 50%, #1e293b 100%);">
        <div class="hero-content">
            <div class="hero-greeting">لوحة التحكم 🛡️</div>
            <h1 class="hero-title">الأدوار والصلاحيات</h1>
            <p class="hero-subtitle">إدارة أدوار المستخدمين ومنح الصلاحيات (<?php echo e($roles->total()); ?> دور)</p>
            <div class="hero-actions d-flex gap-2">
                <form action="<?php echo e(route('roles.index')); ?>" method="GET" class="d-none d-md-flex">
                    <div class="input-group input-group-sm">
                        <input type="text" name="q" class="form-control rounded-pill-start border-0" placeholder="بحث عن دور..." value="<?php echo e(request('q')); ?>" style="min-width: 200px;">
                        <button class="btn btn-light rounded-pill-end border-0 text-primary" type="submit"><i class="bi bi-search"></i></button>
                    </div>
                </form>
                <a href="<?php echo e(route('roles.create')); ?>" class="btn btn-sm rounded-pill px-4">
                    <i class="bi bi-plus-lg me-1"></i> إضافة دور جديد
                </a>
            </div>
        </div>
        <i class="bi bi-shield-lock-fill hero-icon d-none d-md-block"></i>
    </div>

    <div class="chart-container animate-slide-up animate-delay-1">
        <div class="card-body p-0">
            <div class="table-responsive">
                <table class="table table-hover align-middle mb-0">
                    <thead class="bg-transparent">
                        <tr>
                            <th class="border-0 p-3 ps-4">الدور</th>
                            <th class="border-0 p-3">المعرف (Key)</th>
                            <th class="border-0 p-3">الوصف</th>
                            <th class="border-0 p-3 text-end pe-4">الإجراءات</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__empty_1 = true; $__currentLoopData = $roles; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $r): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                            <tr onclick="window.location='<?php echo e(route('roles.show', $r)); ?>'" style="cursor: pointer;">
                                <td class="p-3 ps-4">
                                    <div class="d-flex align-items-center">
                                        <div class="avatar-initial rounded bg-primary-subtle text-primary fw-bold me-3 d-flex align-items-center justify-content-center"
                                            style="width: 40px; height: 40px;">
                                            <?php echo e(strtoupper(substr($r->key, 0, 1))); ?>

                                        </div>
                                        <span class="fw-bold text-body"><?php echo e($r->name); ?></span>
                                    </div>
                                </td>
                                <td class="p-3">
                                    <span class="badge bg-secondary-subtle text-body border font-monospace"><?php echo e($r->key); ?></span>
                                </td>
                                <td class="p-3 text-muted">
                                    <?php echo e($r->description ?? '—'); ?>

                                </td>
                                <td class="p-3 text-end pe-4">
                                    <div class="btn-group" onclick="event.stopPropagation()">
                                        <a href="<?php echo e(route('roles.show', $r)); ?>" class="btn btn-sm btn-outline-secondary"
                                            title="عرض الصلاحيات">
                                            <i class="bi bi-shield-lock"></i>
                                        </a>
                                        <a href="<?php echo e(route('roles.edit', $r)); ?>" class="btn btn-sm btn-outline-primary"
                                            title="تعديل">
                                            <i class="bi bi-pencil"></i>
                                        </a>
                                        <button type="button" class="btn btn-sm btn-outline-danger"
                                            onclick="if(confirm('هل أنت متأكد من حذف هذا الدور؟')) document.getElementById('del-<?php echo e($r->id); ?>').submit()"
                                            title="حذف">
                                            <i class="bi bi-trash"></i>
                                        </button>
                                    </div>
                                    <form id="del-<?php echo e($r->id); ?>" action="<?php echo e(route('roles.destroy', $r)); ?>" method="POST"
                                        class="d-none">
                                        <?php echo csrf_field(); ?> <?php echo method_field('DELETE'); ?>
                                    </form>
                                </td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                            <tr>
                                <td colspan="4" class="text-center py-5 text-muted">
                                    <i class="bi bi-shield-x display-4 mb-3 d-block opacity-50"></i>
                                    لا توجد أدوار معرفة في النظام
                                </td>
                            </tr>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
        </div>
        <?php if($roles->hasPages()): ?>
            <div class="card-footer bg-transparent border-0 py-3">
                <?php echo e($roles->links()); ?>

            </div>
        <?php endif; ?>
    </div>

<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\Users\HP\Downloads\ensan\System.Ensan-main\System.Ensan-main\resources\views/roles/index.blade.php ENDPATH**/ ?>