<?php $__env->startSection('content'); ?>


<div class="dashboard-hero animate-slide-up" style="background: linear-gradient(135deg, #3b82f6 0%, #2563eb 50%, #1d4ed8 100%);">
    <div class="hero-content">
        <div class="hero-greeting">المحاسبة 📒</div>
        <h1 class="hero-title">القيود اليومية</h1>
        <p class="hero-subtitle">إدارة ومراجعة قيود اليومية والعمليات المالية</p>
        <div class="hero-actions d-flex gap-2">
            <a href="<?php echo e(route('journal-entries.create')); ?>" class="btn btn-sm rounded-pill px-4">
                <i class="bi bi-plus-lg me-1"></i> إضافة قيد
            </a>
        </div>
    </div>
    <i class="bi bi-journal-bookmark hero-icon d-none d-md-block"></i>
</div>

<div class="chart-container animate-slide-up animate-delay-1 mb-4">
        <div class="table-responsive">
            <table class="table table-hover align-middle mb-0">
                <thead class="bg-transparent">
                    <tr>
                        <th>#</th>
                        <th>التاريخ</th>
                        <th>الوصف</th>
                        <th>النوع</th>
                        <th>إجمالي</th>
                        <th>الحالة</th>
                        <th>إجراءات</th>
                    </tr>
                </thead>
                <tbody>
                    <?php $__currentLoopData = $entries; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $entry): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr>
                            <td><?php echo e($entry->id); ?></td>
<td><?php echo e(optional($entry->date)->format('Y-m-d')); ?></td>
                            <td><?php echo e(Str::limit($entry->description, 50)); ?></td>
                            <td><?php echo e($entry->entry_type); ?></td>
                            <td><?php echo e($entry->lines->sum('debit')); ?></td>
                            <td>
                                <?php if($entry->locked): ?> <span class="badge bg-secondary">مغلق</span> <?php else: ?> <span
                                class="badge bg-success">مفتوح</span> <?php endif; ?>
                            </td>
                            <td class="text-end position-static">
                                <div class="dropdown">
                                    <button class="btn btn-sm btn-outline-secondary rounded-pill px-3" type="button" data-bs-toggle="dropdown" data-bs-boundary="viewport">
                                        <i class="bi bi-three-dots"></i> خيارات
                                    </button>
                                    <ul class="dropdown-menu dropdown-menu-end shadow-sm border-0">
                                        <li><a class="dropdown-item py-2" href="<?php echo e(route('journal-entries.show', $entry)); ?>"><i class="bi bi-eye me-2 text-primary"></i> عرض التفاصيل</a></li>
                                        <?php if(!$entry->locked): ?>
                                            <?php $isAdminOrManager = auth()->user()->hasRole('admin') || auth()->user()->hasRole('manager'); ?>
                                            <li><a class="dropdown-item py-2" href="<?php echo e(route('journal-entries.edit', $entry)); ?>"><i class="bi bi-pencil me-2 text-secondary"></i> <?php echo e($isAdminOrManager ? 'تعديل' : 'طلب تعديل'); ?></a></li>
                                            <li><hr class="dropdown-divider"></li>
                                            <li>
                                                <form method="POST" action="<?php echo e(route('journal-entries.destroy', $entry)); ?>" onsubmit="return confirm('هل أنت متأكد من <?php echo e($isAdminOrManager ? 'حذف' : 'طلب حذف'); ?> هذا القيد؟');">
                                                    <?php echo csrf_field(); ?> <?php echo method_field('DELETE'); ?>
                                                    <button class="dropdown-item py-2 text-danger"><i class="bi bi-trash me-2"></i> <?php echo e($isAdminOrManager ? 'حذف نهائي' : 'طلب حذف'); ?></button>
                                                </form>
                                            </li>
                                        <?php endif; ?>
                                    </ul>
                                </div>
                            </td>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>
            </table>
            <?php echo e($entries->links()); ?>

        </div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\Users\HP\Downloads\ensan\System.Ensan-main\System.Ensan-main\resources\views/journal_entries/index.blade.php ENDPATH**/ ?>