<?php $__env->startSection('content'); ?>
<link href="https://fonts.googleapis.com/css2?family=Outfit:wght@300;400;600;700&family=Tajawal:wght@300;400;500;700;800&display=swap" rel="stylesheet">

<div class="settings-page">
    <div class="premium-hero-sleek">
        <div class="hero-bg-visuals">
            <div class="glow-orb-1" style="background: #06b6d4;"></div>
            <div class="glow-orb-2" style="background: #334155;"></div>
            <div class="noise-overlay"></div>
        </div>
        <div class="hero-content-wrapper container-fluid">
            <div class="row align-items-center">
                <div class="col-lg-8 animate-reveal-right text-end">
                    <nav aria-label="breadcrumb" class="mb-4 d-flex justify-content-end">
                        <ol class="breadcrumb mb-0">
                            <li class="breadcrumb-item"><a href="<?php echo e(route('dashboard.index')); ?>" class="text-white-50 decoration-none">لوحة التحكم</a></li>
                            <li class="breadcrumb-item active text-white" aria-current="page">محتوى الصفحة الرئيسية</li>
                        </ol>
                    </nav>
                    <div class="d-flex align-items-center justify-content-end gap-3 mb-3">
                        <div class="badge-glass-premium">
                            <i class="bi bi-gear-wide-connected me-2"></i> إعدادات الموقع العام
                        </div>
                    </div>
                    <h1 class="display-4 fw-800 text-white mb-3 text-end">محتوى الصفحة الرئيسية</h1>
                    <p class="lead text-white-50 mb-0 max-w-600 ms-auto me-0 text-end">
                        تحديث أرقام الإنجاز المباشرة والإعدادات العامة للموقع
                    </p>
                </div>
                <div class="col-lg-4 text-start mt-4 mt-lg-0 animate-reveal-left"></div>
            </div>
        </div>
    </div>

<div class="container-fluid py-4">
    
    <?php if($errors->any()): ?>
        <div class="alert alert-danger alert-dismissible fade show border-0 shadow-sm rounded-4 mb-4" role="alert">
            <div class="d-flex align-items-center">
                <i class="bi bi-exclamation-triangle-fill fs-4 me-3"></i>
                <div>
                    <h6 class="mb-1 fw-bold">حدث خطأ ما!</h6>
                    <ul class="mb-0 small">
                        <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <li><?php echo e($error); ?></li>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </ul>
                </div>
            </div>
            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
        </div>
    <?php endif; ?>

        <div class="row g-4">
            
            <div class="col-lg-8">
                <form action="<?php echo e(route('website.settings.update')); ?>" method="POST" enctype="multipart/form-data" class="glass-card mb-4 overflow-hidden border-0 shadow-sm animate-slide-up stats-card-dark" style="animation-delay: 0.05s;">
                    <?php echo csrf_field(); ?>
                    <div class="p-4 border-bottom border-white border-opacity-10 d-flex justify-content-between align-items-center bg-slate-900">
                        <h5 class="mb-0 fw-bold text-white"><i class="bi bi-megaphone me-2 text-success"></i> شريط الإشعارات (Breaking News)</h5>
                        <button type="submit" class="btn btn-sm btn-success text-white rounded-pill px-4 shadow-sm">حفظ</button>
                    </div>
                    <div class="p-4 bg-slate-900">
                        <div class="form-check form-switch mb-3">
                            <input class="form-check-input" type="checkbox" name="notification_active" id="notifActive" <?php echo e(($settings['notification_active'] ?? '') == 'on' ? 'checked' : ''); ?>>
                            <label class="form-check-label fw-bold text-white" for="notifActive">تفعيل الشريط العلوي</label>
                        </div>
                        <div class="row g-3">
                            <div class="col-md-6">
                                <label class="form-label small fw-bold text-slate-400">النص المميز (Label)</label>
                                <input type="text" name="notification_label" class="form-control form-control-sm bg-dark text-white border-secondary" placeholder="مثلاً: جديد" value="<?php echo e($settings['notification_label'] ?? 'جديد'); ?>">
                            </div>
                            <div class="col-md-6">
                                <label class="form-label small fw-bold text-slate-400">نص الإشعار</label>
                                <input type="text" name="notification_text" class="form-control form-control-sm bg-dark text-white border-secondary" placeholder="مثلاً: انطلاق حملة الشتاء..." value="<?php echo e($settings['notification_text'] ?? ''); ?>">
                            </div>
                            <div class="col-md-6">
                                <label class="form-label small fw-bold text-slate-400">نص الزر</label>
                                <input type="text" name="notification_link_text" class="form-control form-control-sm bg-dark text-white border-secondary" placeholder="مثلاً: اعرف المزيد" value="<?php echo e($settings['notification_link_text'] ?? 'اعرف المزيد'); ?>">
                            </div>
                            <div class="col-md-6">
                                <label class="form-label small fw-bold text-slate-400">رابط الزر (URL)</label>
                                <input type="text" name="notification_link_url" class="form-control form-control-sm bg-dark text-white border-secondary" placeholder="https://..." value="<?php echo e($settings['notification_link_url'] ?? '#'); ?>">
                            </div>
                        </div>
                    </div>
                </form>

                
                <form action="<?php echo e(route('website.settings.update')); ?>" method="POST" enctype="multipart/form-data" class="glass-card mb-4 overflow-hidden border-0 shadow-sm animate-slide-up stats-card-dark" style="animation-delay: 0.1s;">
                    <?php echo csrf_field(); ?>
                    <div class="p-4 border-bottom border-white border-opacity-10 d-flex justify-content-between align-items-center bg-slate-900">
                        <h5 class="mb-0 fw-bold text-white"><i class="bi bi-layout-text-window me-2 text-primary"></i> محتوى الواجهة الرئيسية (Hero)</h5>
                        <button type="submit" class="btn btn-sm btn-primary text-white rounded-pill px-4 shadow-sm fw-bold">حفظ</button>
                    </div>
                    <div class="p-4 bg-slate-900">
                        <div class="row g-3">
                            <div class="col-md-6">
                                <label class="form-label small fw-bold text-slate-400">العنوان الرئيسي (الجزء الأول)</label>
                                <input type="text" name="hero_title_primary" class="form-control bg-dark text-white border-secondary" value="<?php echo e($settings['hero_title_primary'] ?? ''); ?>">
                            </div>
                            <div class="col-md-6">
                                <label class="form-label small fw-bold text-slate-400">العنوان الرئيسي (الجزء الثاني - لون أخضر)</label>
                                <input type="text" name="hero_title_secondary" class="form-control bg-dark text-white border-secondary" value="<?php echo e($settings['hero_title_secondary'] ?? ''); ?>">
                            </div>
                            <div class="col-12">
                                <label class="form-label small fw-bold text-slate-400">وصف المؤسسة (عن إنسان)</label>
                                <textarea name="hero_description" class="form-control bg-dark text-white border-secondary" rows="4"><?php echo e($settings['hero_description'] ?? ''); ?></textarea>
                            </div>
                        </div>
                    </div>
                </form>

                
                <form action="<?php echo e(route('website.settings.update')); ?>" method="POST" enctype="multipart/form-data" class="glass-card mb-4 overflow-hidden border-0 shadow-sm animate-slide-up stats-card-dark" style="animation-delay: 0.15s;">
                    <?php echo csrf_field(); ?>
                    <div class="p-4 border-bottom border-white border-opacity-10 d-flex justify-content-between align-items-center bg-slate-900">
                        <h5 class="mb-0 fw-bold text-white"><i class="bi bi-graph-up-arrow me-2 text-info"></i> أرقام الإنجازات (Stats)</h5>
                        <button type="submit" class="btn btn-sm btn-info text-white rounded-pill px-4 shadow-sm">حفظ الإحصائيات</button>
                    </div>
                    <div class="p-4 bg-slate-900">
                        <div class="row g-3">
                            <div class="col-md-6 col-lg">
                                <div class="p-4 rounded-4 bg-light border text-center statistics-box h-100">
                                    <input type="text" name="stats_beneficiaries_label" class="form-control form-control-sm text-center x-small fw-bold text-muted border-0 bg-transparent mb-1 p-0" value="<?php echo e($settings['stats_beneficiaries_label'] ?? 'المشاريع'); ?>" placeholder="العنوان">
                                    <input type="text" name="stats_beneficiaries" class="form-control form-control-lg text-center fw-bold border-0 bg-transparent p-0" value="<?php echo e($settings['stats_beneficiaries'] ?? '600K'); ?>">
                                    <div class="mt-2 text-success"><i class="bi bi-people-fill fs-5"></i></div>
                                </div>
                            </div>

                            <div class="col-md-6 col-lg">
                                <div class="p-4 rounded-4 bg-light border text-center statistics-box h-100">
                                    <input type="text" name="stats_governorates_label" class="form-control form-control-sm text-center x-small fw-bold text-muted border-0 bg-transparent mb-1 p-0" value="<?php echo e($settings['stats_governorates_label'] ?? 'المحافظات (كفر الشيخ ...)'); ?>" placeholder="العنوان">
                                    <input type="text" name="stats_governorates" class="form-control form-control-lg text-center fw-bold border-0 bg-transparent p-0" value="<?php echo e($settings['stats_governorates'] ?? '45'); ?>">
                                    <div class="mt-2 text-info"><i class="bi bi-geo-alt fs-5"></i></div>
                                </div>
                            </div>
                            <div class="col-md-6 col-lg">
                                <div class="p-4 rounded-4 bg-light border text-center statistics-box h-100">
                                    <input type="text" name="stats_donations_label" class="form-control form-control-sm text-center x-small fw-bold text-muted border-0 bg-transparent mb-1 p-0" value="<?php echo e($settings['stats_donations_label'] ?? 'التبرعات'); ?>" placeholder="العنوان">
                                    <input type="text" name="stats_donations" class="form-control form-control-lg text-center fw-bold border-0 bg-transparent p-0" value="<?php echo e($settings['stats_donations'] ?? ''); ?>">
                                    <div class="mt-2 text-info"><i class="bi bi-cash-stack fs-5"></i></div>
                                </div>
                            </div>
                            <div class="col-md-6 col-lg">
                                <div class="p-4 rounded-4 bg-light border text-center statistics-box h-100">
                                    <input type="text" name="stats_volunteers_label" class="form-control form-control-sm text-center x-small fw-bold text-muted border-0 bg-transparent mb-1 p-0" value="<?php echo e($settings['stats_volunteers_label'] ?? 'المتطوعون'); ?>" placeholder="العنوان">
                                    <input type="text" name="stats_volunteers" class="form-control form-control-lg text-center fw-bold border-0 bg-transparent p-0" value="<?php echo e($settings['stats_volunteers'] ?? ''); ?>">
                                    <div class="mt-2 text-info"><i class="bi bi-heart fs-5"></i></div>
                                </div>
                            </div>
                        </div>
                    </div>
                </form>

                
                <form action="<?php echo e(route('website.settings.update')); ?>" method="POST" enctype="multipart/form-data" class="glass-card mb-4 overflow-hidden border-0 shadow-sm animate-slide-up stats-card-dark" style="animation-delay: 0.2s;">
                    <?php echo csrf_field(); ?>
                    <div class="p-4 border-bottom border-white border-opacity-10 d-flex justify-content-between align-items-center bg-slate-900">
                        <h5 class="mb-0 fw-bold text-white"><i class="bi bi-images me-2 text-warning"></i> صور شريط الإعلانات الرئيسي (Slider)</h5>
                        <button type="submit" class="btn btn-sm btn-warning text-dark rounded-pill px-4 shadow-sm fw-bold">حفظ الصور</button>
                    </div>
                    <div class="p-4 bg-slate-900">
                        <div class="row g-3">
                            <?php for($i = 1; $i <= 6; $i++): ?>
                            <div class="col-6">
                                <label class="form-label d-block text-slate-400 small fw-bold">الصورة #<?php echo e($i); ?></label>
                                <div class="position-relative shadow-sm rounded-3 overflow-hidden" 
                                     style="height: 100px; background: rgba(255,255,255,0.05); border: 1px dashed rgba(255,255,255,0.2);">
                                    <?php 
                                        $path = $settings['gallery_image_'.$i] ?? null; 
                                        if($path) $path = str_replace('\\', '/', $path);
                                    ?>
                                    <input type="hidden" name="delete_gallery_image_<?php echo e($i); ?>" id="delete_gallery_image_<?php echo e($i); ?>" value="0">
                                    <img src="<?php echo e($path ? asset('storage/' . $path) . '?v=' . time() : ''); ?>" class="w-100 h-100 object-fit-cover <?php echo e(!$path ? 'd-none' : ''); ?>" id="galImg<?php echo e($i); ?>">
                                    
                                    <div class="w-100 h-100 d-flex flex-column align-items-center justify-content-center text-muted <?php echo e($path ? 'd-none' : ''); ?>" id="galPlaceholder<?php echo e($i); ?>">
                                        <i class="bi bi-image x-small"></i>
                                    </div>
                                    <input type="file" name="gallery_image_<?php echo e($i); ?>" class="position-absolute top-0 start-0 w-100 h-100 opacity-0 cursor-pointer" 
                                           onchange="previewItem(this, <?php echo e($i); ?>, 'gal')">
                                    
                                    <button type="button" class="btn btn-sm btn-danger position-absolute top-0 end-0 m-1 p-1 rounded-circle <?php echo e(!$path ? 'd-none' : ''); ?>" 
                                            style="width: 24px; height: 24px; z-index: 5;"
                                            onclick="deleteImage('gal', <?php echo e($i); ?>)">
                                        <i class="bi bi-x"></i>
                                    </button>
                                </div>
                            </div>
                            <?php endfor; ?>
                        </div>
                    </div>
                </form>

                
                <form action="<?php echo e(route('website.settings.update')); ?>" method="POST" enctype="multipart/form-data" class="glass-card mb-4 overflow-hidden border-0 shadow-sm animate-slide-up stats-card-dark" style="animation-delay: 0.25s;">
                    <?php echo csrf_field(); ?>
                    <div class="p-4 border-bottom border-white border-opacity-10 d-flex justify-content-between align-items-center bg-slate-900">
                        <h5 class="mb-0 fw-bold text-white"><i class="bi bi-megaphone me-2 text-warning"></i> قسم حملاتنا الجارية (Campaigns Section)</h5>
                        <button type="submit" class="btn btn-sm btn-warning text-dark rounded-pill px-4 shadow-sm fw-bold">حفظ</button>
                    </div>
                    <div class="p-4 bg-slate-900">
                        <div class="row g-3">
                            <div class="col-md-6">
                                <label class="form-label small fw-bold text-slate-400">عنوان القسم الرئيسي</label>
                                <input type="text" name="campaigns_title" class="form-control bg-dark text-white border-secondary" value="<?php echo e($settings['campaigns_title'] ?? 'حملاتنا الجارية تنتظر مساهمتك'); ?>">
                            </div>
                            <div class="col-md-6">
                                <label class="form-label small fw-bold text-slate-400">العنوان الفرعي</label>
                                <input type="text" name="campaigns_subtitle" class="form-control bg-dark text-white border-secondary" value="<?php echo e($settings['campaigns_subtitle'] ?? 'مساهمتك قد تغير حياة الآخرين للأفضل'); ?>">
                            </div>
                        </div>
                    </div>
                </form>

                
                <form action="<?php echo e(route('website.settings.update')); ?>" method="POST" enctype="multipart/form-data" class="glass-card mb-4 overflow-hidden border-0 shadow-sm animate-slide-up stats-card-dark" style="animation-delay: 0.3s;">
                    <?php echo csrf_field(); ?>
                    <div class="p-4 border-bottom border-white border-opacity-10 d-flex justify-content-between align-items-center bg-slate-900">
                        <h5 class="mb-0 fw-bold text-white"><i class="bi bi-house-heart me-2 text-danger"></i> قسم ضيافة إنسان (الصفحة الرئيسية)</h5>
                        <button type="submit" class="btn btn-sm btn-danger text-white rounded-pill px-4 shadow-sm fw-bold">حفظ</button>
                    </div>
                    <div class="p-4 bg-slate-900">
                        <div class="row g-3">
                            <div class="col-12">
                                <label class="form-label small fw-bold text-slate-400">عنوان القسم</label>
                                <input type="text" name="gh_home_title" class="form-control bg-dark text-white border-secondary" value="<?php echo e($settings['gh_home_title'] ?? 'ضيافة إنسان'); ?>">
                            </div>
                            <div class="col-12">
                                <label class="form-label small fw-bold text-slate-400">المحتوى المختصر</label>
                                <textarea name="gh_home_content" class="form-control bg-dark text-white border-secondary" rows="3"><?php echo e($settings['gh_home_content'] ?? ''); ?></textarea>
                            </div>
                            <div class="col-12">
                                <label class="form-label small fw-bold text-slate-400">صورة القسم</label>
                                <?php $ghImg = $settings['gh_home_image'] ?? null; ?>
                                <?php if($ghImg): ?>
                                    <div class="mb-2 position-relative d-inline-block">
                                        <img src="<?php echo e(asset('storage/' . $ghImg)); ?>?v=<?php echo e(time()); ?>" class="rounded-3 shadow-sm" style="max-height: 150px; max-width: 100%;">
                                        <input type="hidden" name="delete_gh_home_image" id="delete_gh_home_image" value="0">
                                        <button type="button" class="btn btn-sm btn-danger position-absolute top-0 end-0 m-1 rounded-circle" style="width: 28px; height: 28px;"
                                                onclick="if(confirm('هل أنت متأكد من حذف الصورة؟')){ document.getElementById('delete_gh_home_image').value='1'; this.closest('form').submit(); }">
                                            <i class="bi bi-x"></i>
                                        </button>
                                    </div>
                                    <div class="text-success small mb-2"><i class="bi bi-check-circle"></i> صورة مرفوعة بنجاح</div>
                                <?php endif; ?>
                                <input type="file" name="gh_home_image" class="form-control bg-dark text-white border-secondary">
                            </div>
                        </div>
                    </div>
                </form>

                
                <form action="<?php echo e(route('website.settings.update')); ?>" method="POST" enctype="multipart/form-data" class="glass-card mb-4 overflow-hidden border-0 shadow-sm animate-slide-up stats-card-dark" style="animation-delay: 0.35s;">
                    <?php echo csrf_field(); ?>
                    <div class="p-4 border-bottom border-white border-opacity-10 d-flex justify-content-between align-items-center bg-slate-900">
                        <h5 class="mb-0 fw-bold text-white"><i class="bi bi-patch-check me-2 text-info"></i> قسم الشريك الأمثل لتبرعاتك (Ideal Partner)</h5>
                        <button type="submit" class="btn btn-sm btn-info text-white rounded-pill px-4 shadow-sm fw-bold">حفظ</button>
                    </div>
                    <div class="p-4 bg-slate-900">
                        <div class="row g-3">
                            <div class="col-12">
                                <label class="form-label small fw-bold text-slate-400">العنوان الرئيسي للقسم</label>
                                <input type="text" name="ideal_partner_title" class="form-control bg-dark text-white border-secondary" value="<?php echo e($settings['ideal_partner_title'] ?? 'الشريك الأمثل لتبرعاتك'); ?>">
                            </div>
                            
                            <h6 class="mt-4 mb-2 small fw-bold text-slate-400">العناصر الأربعة</h6>
                            
                            <?php for($i = 1; $i <= 4; $i++): ?>
                            <?php
                                $defLabels = ['', 'شفافية', 'موظف', 'قرية', 'مؤسسة'];
                                $defValues = ['', '100%', '200+', '200', 'معتمدة'];
                            ?>
                            <div class="col-md-6">
                                <div class="p-3 rounded-4 bg-dark bg-opacity-50 border border-secondary">
                                    <label class="form-label x-small text-slate-400 mb-1">العنصر <?php echo e($i); ?></label>
                                    <div class="row g-2">
                                        <div class="col-6">
                                            <input type="text" name="ideal_partner_item<?php echo e($i); ?>_value" class="form-control form-control-sm bg-slate-800 text-white border-secondary text-center fw-bold" placeholder="القيمة (مثلاً: 100%)" value="<?php echo e($settings['ideal_partner_item'.$i.'_value'] ?? $defValues[$i]); ?>">
                                        </div>
                                        <div class="col-6">
                                            <input type="text" name="ideal_partner_item<?php echo e($i); ?>_label" class="form-control form-control-sm bg-slate-800 text-white border-secondary text-center" placeholder="الوصف (مثلاً: شفافية)" value="<?php echo e($settings['ideal_partner_item'.$i.'_label'] ?? $defLabels[$i]); ?>">
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <?php endfor; ?>
                        </div>
                    </div>
                </form>

                
                <form action="<?php echo e(route('website.settings.update')); ?>" method="POST" enctype="multipart/form-data" class="glass-card mb-4 overflow-hidden border-0 shadow-sm animate-slide-up stats-card-dark" style="animation-delay: 0.4s;">
                    <?php echo csrf_field(); ?>
                    <div class="p-4 border-bottom border-white border-opacity-10 d-flex justify-content-between align-items-center bg-slate-900">
                        <h5 class="mb-0 fw-bold text-white"><i class="bi bi-camera me-2 text-primary"></i> صور من الميدان (Field)</h5>
                        <button type="submit" class="btn btn-sm btn-primary text-white rounded-pill px-4 shadow-sm fw-bold">حفظ الصور</button>
                    </div>
                    <div class="p-4 bg-slate-900">
                        <div class="row g-3">
                            <?php for($i = 1; $i <= 4; $i++): ?>
                            <div class="col-6">
                                <label class="form-label d-block text-slate-400 small fw-bold">صورة الميدان #<?php echo e($i); ?></label>
                                <div class="position-relative shadow-sm rounded-3 overflow-hidden" 
                                     style="height: 100px; background: rgba(255,255,255,0.05); border: 1px dashed rgba(255,255,255,0.2);">
                                    <?php 
                                        $path = $settings['field_image_'.$i] ?? null; 
                                        if($path) $path = str_replace('\\', '/', $path);
                                    ?>
                                    <input type="hidden" name="delete_field_image_<?php echo e($i); ?>" id="delete_field_image_<?php echo e($i); ?>" value="0">
                                    <img src="<?php echo e($path ? asset('storage/' . $path) . '?v=' . time() : ''); ?>" class="w-100 h-100 object-fit-cover <?php echo e(!$path ? 'd-none' : ''); ?>" id="fieldImg<?php echo e($i); ?>">
                                    <div class="w-100 h-100 d-flex flex-column align-items-center justify-content-center text-muted <?php echo e($path ? 'd-none' : ''); ?>" id="fieldPlaceholder<?php echo e($i); ?>">
                                        <i class="bi bi-geo-alt x-small"></i>
                                    </div>
                                    <input type="file" name="field_image_<?php echo e($i); ?>" class="position-absolute top-0 start-0 w-100 h-100 opacity-0 cursor-pointer" 
                                           onchange="previewItem(this, <?php echo e($i); ?>, 'field')">
                                    
                                    <button type="button" class="btn btn-sm btn-danger position-absolute top-0 end-0 m-1 p-1 rounded-circle <?php echo e(!$path ? 'd-none' : ''); ?>" 
                                            style="width: 24px; height: 24px; z-index: 5;"
                                            onclick="deleteImage('field', <?php echo e($i); ?>)">
                                        <i class="bi bi-x"></i>
                                    </button>
                                </div>
                            </div>
                            <?php endfor; ?>
                        </div>
                    </div>
                </form>

                
                <form action="<?php echo e(route('website.settings.update')); ?>" method="POST" enctype="multipart/form-data" class="glass-card mb-5 overflow-hidden border-0 shadow-sm animate-slide-up stats-card-dark" style="animation-delay: 0.45s;">
                    <?php echo csrf_field(); ?>
                    <div class="p-4 border-bottom border-white border-opacity-10 d-flex justify-content-between align-items-center bg-slate-900">
                        <h5 class="mb-0 fw-bold text-white"><i class="bi bi-megaphone-fill me-2 text-success"></i> قسم الدعوة للعمل (Bottom CTA)</h5>
                        <button type="submit" class="btn btn-sm btn-success text-white rounded-pill px-4 shadow-sm fw-bold">حفظ</button>
                    </div>
                    <div class="p-4 bg-slate-900">
                        <div class="row g-3">
                            <div class="col-12">
                                <label class="form-label small fw-bold text-slate-400">العنوان الرئيسي</label>
                                <input type="text" name="cta_title" class="form-control bg-dark text-white border-secondary" value="<?php echo e($settings['cta_title'] ?? 'كن جزءاً من قصة نجاح'); ?>">
                            </div>
                            <div class="col-12">
                                <label class="form-label small fw-bold text-slate-400">النص التحفيزي</label>
                                <textarea name="cta_text" class="form-control bg-dark text-white border-secondary" rows="3"><?php echo e($settings['cta_text'] ?? ''); ?></textarea>
                            </div>
                            <h6 class="mt-3 mb-2 small fw-bold text-slate-400">إحصائيات CTA</h6>
                            <div class="col-md-4">
                                <label class="form-label x-small text-slate-400">قيمة 1</label>
                                <input type="text" name="cta_stat1_value" class="form-control form-control-sm mb-1 bg-dark text-white border-secondary" value="<?php echo e($settings['cta_stat1_value'] ?? '50M+'); ?>">
                                <input type="text" name="cta_stat1_label" class="form-control form-control-sm bg-dark text-white border-secondary" value="<?php echo e($settings['cta_stat1_label'] ?? 'تبرعات'); ?>">
                            </div>
                            <div class="col-md-4">
                                <label class="form-label x-small text-slate-400">قيمة 2</label>
                                <input type="text" name="cta_stat2_value" class="form-control form-control-sm mb-1 bg-dark text-white border-secondary" value="<?php echo e($settings['cta_stat2_value'] ?? '150K+'); ?>">
                                <input type="text" name="cta_stat2_label" class="form-control form-control-sm bg-dark text-white border-secondary" value="<?php echo e($settings['cta_stat2_label'] ?? 'ابتسامة'); ?>">
                            </div>
                            <div class="col-md-4">
                                <label class="form-label x-small text-slate-400">قيمة 3</label>
                                <input type="text" name="cta_stat3_value" class="form-control form-control-sm mb-1 bg-dark text-white border-secondary" value="<?php echo e($settings['cta_stat3_value'] ?? '8+'); ?>">
                                <input type="text" name="cta_stat3_label" class="form-control form-control-sm bg-dark text-white border-secondary" value="<?php echo e($settings['cta_stat3_label'] ?? 'سنوات'); ?>">
                            </div>
                        </div>
                    </div>
                </form>
            </div>
        </div>



<script>
    function previewItem(input, index, prefix) {
        if (input.files && input.files[0]) {
            var reader = new FileReader();
            reader.onload = function(e) {
                const img = document.getElementById(prefix + 'Img' + index);
                const placeholder = document.getElementById(prefix + 'Placeholder' + index);
                const deleteBtn = input.nextElementSibling; // Adjust if structure changes
                
                if(img) {
                    img.src = e.target.result;
                    img.classList.remove('d-none');
                }
                if(placeholder) {
                    placeholder.classList.add('d-none');
                }
                
                // Show delete button for new upload
                const parent = input.parentElement;
                const btn = parent.querySelector('.btn-danger');
                if(btn) btn.classList.remove('d-none');
                
                // Reset delete flag just in case
                const delInput = document.getElementById('delete_' + (prefix === 'gal' ? 'gallery' : 'field') + '_image_' + index);
                if(delInput) delInput.value = '0';
            }
            reader.readAsDataURL(input.files[0]);
        }
    }

    function deleteImage(prefix, index) {
        if(!confirm('هل أنت متأكد من حذف هذه الصورة؟')) return;

        // Visual update
        const img = document.getElementById(prefix + 'Img' + index);
        const placeholder = document.getElementById(prefix + 'Placeholder' + index);
        const fileInput = document.querySelector(`input[name="${prefix === 'gal' ? 'gallery' : 'field'}_image_${index}"]`);
        
        if(img) {
            img.src = '';
            img.classList.add('d-none');
        }
        if(placeholder) {
            placeholder.classList.remove('d-none');
        }
        if(fileInput) {
            fileInput.value = ''; // Clear file input
        }

        // Set hidden input flag
        const type = prefix === 'gal' ? 'gallery' : 'field';
        const delInput = document.getElementById(`delete_${type}_image_${index}`);
        if(delInput) {
            delInput.value = '1';
        }

        // Hide delete button
        const btn = event.target.closest('button');
        if(btn) btn.classList.add('d-none');
    }
</script>

    </div> 
</div> 

<style>
    body { background-color: #0b0e14 !important; }
    .settings-page { min-height: 100vh; }

    /* Premium Hero */
    .premium-hero-sleek { position: relative; padding: 100px 0 120px; background: linear-gradient(135deg, #1e293b 0%, #334155 100%); border-radius: 0 0 60px 60px; overflow: hidden; z-index: 10; box-shadow: 0 20px 50px rgba(0,0,0,0.3); }
    .hero-bg-visuals div { position: absolute; border-radius: 50%; filter: blur(100px); opacity: 0.4; pointer-events: none; }
    .glow-orb-1 { width: 400px; height: 400px; top: -100px; right: -50px; }
    .glow-orb-2 { width: 300px; height: 300px; bottom: -150px; left: -50px; }
    .noise-overlay { position: absolute; inset: 0; opacity: 0.05; }
    .hero-content-wrapper { position: relative; z-index: 5; padding: 0 5%; }
    .badge-glass-premium { background: rgba(255,255,255,0.1); backdrop-filter: blur(12px); border: 1px solid rgba(255,255,255,0.1); padding: 8px 18px; border-radius: 100px; color: #a5f3fc; font-weight: 700; font-size: 0.85rem; }
    .fw-800 { font-weight: 800; }
    .max-w-600 { max-width: 600px; }
    .animate-reveal-right { animation: revealRight 1s both; }
    .animate-reveal-left { animation: revealLeft 1s both; }
    @keyframes revealRight { from { opacity: 0; transform: translateX(50px); } to { opacity: 1; transform: translateX(0); } }
    @keyframes revealLeft { from { opacity: 0; transform: translateX(-50px); } to { opacity: 1; transform: translateX(0); } }
    @media (max-width: 991px) { .premium-hero-sleek { border-radius: 0 0 30px 30px; padding: 60px 0 80px; } .display-4 { font-size: 2.2rem; } }

    .glass-card { 
        background: rgba(255,255,255,0.03); 
        backdrop-filter: blur(12px); 
        border: 1px solid rgba(255,255,255,0.08); 
        border-radius: 20px; 
    }
    
    .stats-card-dark { background-color: #0f172a !important; border: 1px solid rgba(255,255,255,0.1); }
    .bg-slate-900 { background-color: #0f172a !important; }
    .text-slate-400 { color: #94a3b8 !important; }
    .border-secondary { border-color: rgba(255,255,255,0.1) !important; }
    
    .x-small { font-size: 0.7rem; }
    .cursor-pointer { cursor: pointer; }
    
    /* Customs Toggle Switch Legacy: Open(On)=Gray, Closed(Off)=Red */
    .form-check-input {
        width: 3em; 
        height: 1.5em; 
        cursor: pointer;
        background-color: #dc3545; /* Red when OFF (Closed) */
        border-color: #dc3545;
    }
    .form-check-input:checked {
        background-color: #6c757d; /* Gray when ON (Open) - "No Color" */
        border-color: #6c757d;
    }
    .form-check-input:focus {
        box-shadow: none; 
    }
    .hero-content {
        user-select: none;
    }

    .statistics-box {
        transition: all 0.3s ease;
    }
    .statistics-box:hover {
        transform: translateY(-5px);
        box-shadow: 0 10px 20px rgba(0,0,0,0.05);
    }

    /* Dark Mode Support */
    [data-bs-theme="dark"] .glass-card {
        background: rgba(30, 41, 59, 0.7) !important;
        border-color: rgba(255, 255, 255, 0.1) !important;
        color: #f8fafc;
    }
    [data-bs-theme="dark"] .bg-light { background-color: rgba(255,255,255,0.05) !important; border-color: rgba(255,255,255,0.1) !important; }
    [data-bs-theme="dark"] .statistics-box { border-color: rgba(255,255,255,0.1) !important; }
    [data-bs-theme="dark"] input.form-control { color: #fff !important; }

    /* Campaign Card Preview Styles */
    .campaign-card {
        transition: transform 0.3s ease, box-shadow 0.3s ease;
    }
    .hover-elevate:hover {
        transform: translateY(-5px);
        box-shadow: 0 15px 30px rgba(0,0,0,0.1) !important;
    }
    .bg-gradient-overlay {
        background: linear-gradient(to bottom, rgba(0,0,0,0.3) 0%, rgba(0,0,0,0) 50%, rgba(0,0,0,0.6) 100%);
    }
    .backdrop-blur {
        backdrop-filter: blur(4px);
    }
    .glass-icon {
        background: rgba(255, 255, 255, 0.25);
        border: 1px solid rgba(255, 255, 255, 0.4);
    }
    .line-clamp-2 {
        display: -webkit-box;
        -webkit-line-clamp: 2;
        -webkit-box-orient: vertical;
        overflow: hidden;
    }
    .shadow-inner {
        box-shadow: inset 0 2px 4px rgba(0,0,0,0.06);
    }
    .animate-pulse {
        animation: pulse 2s infinite;
    }
    @keyframes pulse {
        0% { opacity: 1; }
        50% { opacity: 0.5; }
        100% { opacity: 1; }
    }
    .btn-hover-scale {
        transition: transform 0.2s;
    }
    .btn-hover-scale:hover {
        transform: scale(1.02);
    }
</style>


<div class="toast-container position-fixed bottom-0 end-0 p-3" style="z-index: 9999">
  <div id="saveToast" class="toast align-items-center text-white bg-success border-0" role="alert" aria-live="assertive" aria-atomic="true">
    <div class="d-flex">
      <div class="toast-body fw-bold">
        <i class="bi bi-check-circle-fill me-2"></i> <span id="toastMessage"><?php echo e(session('success') ?? 'تم حفظ التعديلات بنجاح!'); ?></span>
      </div>
      <button type="button" class="btn-close btn-close-white me-2 m-auto" data-bs-dismiss="toast" aria-label="Close"></button>
    </div>
  </div>
</div>

<script>
    document.addEventListener('DOMContentLoaded', function() {
        // Scroll Position Restoration
        const scrollPos = localStorage.getItem('settingsScrollPos');
        if (scrollPos) {
            window.scrollTo(0, parseInt(scrollPos));
            localStorage.removeItem('settingsScrollPos');
        }

        // Show success toast if session success exists
        const hasSuccess = <?php echo session('success') ? 'true' : 'false'; ?>;
        if (hasSuccess) {
            const toastEl = document.getElementById('saveToast');
            if (toastEl) {
                const toast = new bootstrap.Toast(toastEl, { delay: 4000 });
                toast.show();
            }
        }

        // Attach listener to all relevant forms to save scroll position
        const allForms = document.querySelectorAll('form');
        allForms.forEach(form => {
            if (form.method.toLowerCase() === 'post') {
                form.addEventListener('submit', function() {
                    localStorage.setItem('settingsScrollPos', window.scrollY);
                });
            }
        });
    });
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', ['hideGlobalAlerts' => true], array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\Users\HP\Downloads\ensan\System.Ensan-main\System.Ensan-main\resources\views/website/settings.blade.php ENDPATH**/ ?>