<?php $__env->startSection('content'); ?>
    <div class="container-fluid">
        <div class="row">
            <!-- Sidebar Info -->
            <div class="col-md-3 mb-4">
                <div class="card border-0 shadow-sm text-center h-100">
                    <div class="card-body p-4">
                        <div class="mb-4">
                            <div class="bg-primary-subtle text-primary rounded-circle d-inline-flex align-items-center justify-content-center fw-bold display-4"
                                style="width: 100px; height: 100px;">
                                <?php echo e(strtoupper(substr($role->key, 0, 1))); ?>

                            </div>
                        </div>
                        <h4 class="fw-bold mb-1"><?php echo e($role->name); ?></h4>
                        <p class="badge bg-secondary-subtle text-body border mb-3 fs-6"><?php echo e($role->key); ?></p>

                        <?php if($role->description): ?>
                            <p class="text-muted small mb-4"><?php echo e($role->description); ?></p>
                        <?php endif; ?>

                        <div class="d-grid gap-2">
                            <a href="<?php echo e(route('roles.edit', $role)); ?>" class="btn btn-primary">
                                <i class="bi bi-pencil-square me-2"></i> تعديل الدور
                            </a>
                            <a href="<?php echo e(route('roles.index')); ?>" class="btn btn-outline-secondary">
                                <i class="bi bi-arrow-right me-2"></i> رجوع للقائمة
                            </a>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Permissions List -->
            <div class="col-md-9">
                <div class="card border-0 shadow-sm">
                    <div class="card-header bg-transparent py-3 border-bottom-0">
                        <div class="d-flex align-items-center justify-content-between">
                            <h5 class="mb-0 fw-bold"><i class="bi bi-shield-check me-2 text-success"></i> الصلاحيات الممنوحة
                            </h5>
                            <span class="badge bg-success-subtle text-success"><?php echo e($role->permissions->count()); ?>

                                صلاحية</span>
                        </div>
                    </div>
                    <div class="card-body">
                        <?php if($role->permissions->count() > 0): ?>
                            <div class="row g-4">
                                <?php $__currentLoopData = $permissions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $group => $perms): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <div class="col-md-6 col-xl-4">
                                        <div class="border rounded p-3 h-100 bg-body-tertiary">
                                            <h6
                                                class="text-uppercase fw-bold text-primary mb-3 pb-2 border-bottom d-flex align-items-center">
                                                <i class="bi bi-shield-check me-2"></i>
                                                <?php echo e($group); ?>

                                            </h6>
                                            <ul class="list-unstyled mb-0">
                                                <?php $__currentLoopData = $perms; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $perm): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <li class="mb-2 d-flex align-items-start">
                                                        <i class="bi bi-check-circle-fill text-success me-2 mt-1"></i>
                                                        <div>
                                                            <span class="d-block fw-medium"><?php echo e($perm->name); ?></span>
                                                            <small class="text-muted font-monospace"
                                                                style="font-size: 0.75rem;"><?php echo e($perm->key); ?></small>
                                                        </div>
                                                    </li>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </ul>
                                        </div>
                                    </div>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </div>
                        <?php else: ?>
                            <div class="text-center py-5">
                                <div class="mb-3">
                                    <i class="bi bi-shield-exclamation display-1 text-muted opacity-25"></i>
                                </div>
                                <h5 class="text-muted">لا توجد صلاحيات ممنوحة لهذا الدور</h5>
                                <p class="text-muted small">قم بتعديل الدور لإضافة صلاحيات جديدة.</p>
                                <a href="<?php echo e(route('roles.edit', $role)); ?>" class="btn btn-sm btn-outline-primary mt-2">
                                    <i class="bi bi-plus-lg"></i> إضافة صلاحيات
                                </a>
                            </div>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\Users\HP\Downloads\ensan\System.Ensan-main\System.Ensan-main\resources\views/roles/show.blade.php ENDPATH**/ ?>