<?php $__env->startSection('content'); ?>
<div class="revenue-system-container animate-fade-in">
    
    <div class="premium-hero-card mb-4 overflow-hidden position-relative" style="background: linear-gradient(135deg, #059669 0%, #047857 100%); border-radius: 24px;">
        <div class="row align-items-center p-5 position-relative" style="z-index: 2;">
            <div class="col-md-7">
                <span class="badge bg-white bg-opacity-10 text-white px-3 py-2 rounded-pill mb-3">
                    <i class="bi bi-graph-up-arrow me-1"></i> التحليل المالي للإيرادات
                </span>
                <h1 class="display-5 fw-bold text-white mb-2">لوحة الإيرادات والتبرعات</h1>
                <p class="text-white text-opacity-75 lead">نظرة شاملة على مصادر الدخل، أنواع التبرعات، ونمط النمو المالي.</p>
                <div class="d-flex gap-3 mt-4">
                    <button class="btn btn-outline-light btn-lg px-4 rounded-pill shadow-premium fw-bold" onclick="window.print()">
                        <i class="bi bi-printer me-2"></i> طباعة التقرير
                    </button>
                    <!-- <a href="<?php echo e(route('donations.create')); ?>" class="btn btn-outline-light btn-lg px-4 rounded-pill">
                        <i class="bi bi-plus-lg me-2"></i> تسجيل تبرع
                    </a> -->
                </div>
            </div>
            <div class="col-md-5 d-none d-md-block text-center text-md-end">
                <div class="main-stat-circle" style="border-top-color: #fff;">
                    <div class="stat-value text-white h1 fw-bold mb-0"><?php echo e(number_format($totalRevenue, 0)); ?></div>
                    <div class="stat-label text-white text-opacity-75">إجمالي الفترة</div>
                </div>
            </div>
        </div>
        <div class="bg-decoration-circle circle-1" style="background: rgba(255, 255, 255, 0.1);"></div>
        <div class="bg-decoration-circle circle-2" style="background: rgba(255, 255, 255, 0.05);"></div>
    </div>

    
    <div class="glass-container p-4 mb-4">
        <form method="GET" action="<?php echo e(route('revenues.index')); ?>">
            <div class="row g-3 align-items-end">
                <div class="col-md-4">
                    <label class="form-label fw-bold text-muted small">من تاريخ</label>
                    <input type="date" name="start_date" class="form-control" value="<?php echo e($startDate); ?>">
                </div>
                <div class="col-md-4">
                    <label class="form-label fw-bold text-muted small">إلى تاريخ</label>
                    <input type="date" name="end_date" class="form-control" value="<?php echo e($endDate); ?>">
                </div>
                <div class="col-md-4">
                    <button type="submit" class="btn btn-primary w-100 fw-bold rounded-pill">
                        <i class="bi bi-funnel-fill me-2"></i> تحديث التحليل
                    </button>
                </div>
            </div>
        </form>
    </div>

    
    <?php if(count($insights) > 0): ?>
    <div class="row g-4 mb-4">
        <?php $__currentLoopData = $insights; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $insight): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <div class="col-12">
            <div class="alert alert-<?php echo e($insight['type']); ?> border-0 shadow-sm rounded-4 d-flex align-items-center p-3 animate-slide-up">
                <i class="bi bi-<?php echo e($insight['type'] == 'success' ? 'graph-up-arrow' : 'exclamation-triangle'); ?> fs-3 me-3"></i>
                <div>
                    <h6 class="fw-bold mb-1">تحليل الذكاء الاصطناعي</h6>
                    <p class="mb-0 small"><?php echo e($insight['message']); ?></p>
                </div>
            </div>
        </div>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </div>
    <?php endif; ?>

    <div class="row g-4 mb-4">
        
        <div class="col-xl-6">
            <div class="glass-container p-4 h-100">
                <h5 class="fw-bold mb-4">مصادر الإيرادات (Source)</h5>
                <div class="row align-items-center">
                    <div class="col-md-6">
                        <canvas id="sourceChart" height="200"></canvas>
                    </div>
                    <div class="col-md-6">
                        <ul class="list-group list-group-flush">
                            <?php $__currentLoopData = $revenueBySource; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $label => $data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <li class="list-group-item bg-transparent d-flex justify-content-between align-items-center border-0 px-0">
                                <span class="small fw-bold"><i class="bi bi-circle-fill me-2 text-success" style="font-size: 8px"></i> 
                                    <?php echo e($label); ?>

                                </span>
                                <div class="text-end">
                                    <div class="fw-bold"><?php echo e(number_format($data['total'])); ?></div>
                                    <small class="text-muted"><?php echo e(number_format($data['percentage'], 1)); ?>%</small>
                                </div>
                            </li>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </ul>
                    </div>
                </div>
            </div>
        </div>

        
        <div class="col-xl-6">
            <div class="glass-container p-4 h-100">
                <h5 class="fw-bold mb-4">طبيعة الدخل (Type)</h5>
                <canvas id="typeChart" height="250"></canvas>
            </div>
        </div>
    </div>
    
    <div class="row g-4 mb-4">
         
         <div class="col-md-6">
            <div class="glass-container p-4 h-100">
                <h5 class="fw-bold mb-3">أكثر المشاريع/الخدمات دخلاً</h5>
                <?php $__currentLoopData = $revenueByProject; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $name => $total): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <div class="mb-3">
                    <div class="d-flex justify-content-between mb-1">
                        <span class="small fw-bold"><?php echo e($name); ?></span>
                        <span class="small fw-bold"><?php echo e(number_format($total)); ?></span>
                    </div>
                    <?php $pct = $totalRevenue > 0 ? ($total / $totalRevenue) * 100 : 0; ?>
                    <div class="progress" style="height: 6px;">
                        <div class="progress-bar bg-success" style="width: <?php echo e($pct); ?>%"></div>
                    </div>
                </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
         </div>

         
         <div class="col-md-6">
            <div class="glass-container p-0 h-100 overflow-hidden">
                <div class="p-4 border-bottom bg-light bg-opacity-50">
                    <h5 class="fw-bold mb-0">أحدث العمليات المالية</h5>
                </div>
                <div class="table-responsive">
                    <table class="table table-hover align-middle mb-0">
                        <tbody>
                            <?php $__currentLoopData = $recentRevenues; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $r): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr class="<?php echo e(isset($r['is_outflow']) ? 'bg-danger bg-opacity-10' : ''); ?>">
                                <td class="px-4 py-3">
                                    <div class="d-flex align-items-center">
                                        <div class="bg-<?php echo e($r['source'] == 'workspace' ? 'primary' : ($r['source'] == 'expense' ? 'danger' : 'success')); ?> bg-opacity-10 text-<?php echo e($r['source'] == 'workspace' ? 'primary' : ($r['source'] == 'expense' ? 'danger' : 'success')); ?> p-2 rounded-circle me-3">
                                            <i class="bi bi-<?php echo e($r['source'] == 'workspace' ? 'laptop' : ($r['source'] == 'expense' ? 'dash-circle' : 'cash-coin')); ?>"></i>
                                        </div>
                                        <div>
                                            <div class="fw-bold text-dark"><?php echo e($r['description']); ?></div>
                                            <div class="small text-muted"><?php echo e(\Carbon\Carbon::parse($r['date'])->format('Y-m-d')); ?></div>
                                        </div>
                                    </div>
                                </td>
                                <td class="text-end px-4">
                                    <div class="fw-bold text-<?php echo e(isset($r['is_outflow']) ? 'danger' : 'success'); ?>">
                                        <?php echo e(isset($r['is_outflow']) ? '-' : '+'); ?><?php echo e(number_format($r['amount'])); ?>

                                    </div>
                                    <span class="badge bg-light text-dark border"><?php echo e($r['source_label']); ?></span>
                                </td>
                            </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                    </table>
                </div>
            </div>
         </div>
    </div>

</div>

<style>
/* ... existing styles ... */
</style>

<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
<script>
    // Data for charts
    const sourceData = {
        labels: <?php echo json_encode($revenueBySource->keys()); ?>,
        datasets: [{
            data: <?php echo json_encode($revenueBySource->pluck('total')); ?>,
            backgroundColor: ['#10b981', '#3b82f6', '#f59e0b', '#8b5cf6', '#ec4899'],
            borderWidth: 0,
            hoverOffset: 4
        }]
    };

    const typeData = {
        labels: <?php echo json_encode($revenueByType->keys()->map(fn($t) => $t == 'money' ? 'نقدي' : ($t == 'service' ? 'خدمة (إيجار)' : ($t == 'items' ? 'عيني' : $t)))); ?>,
        datasets: [{
            label: 'الإيرادات',
            data: <?php echo json_encode($revenueByType->pluck('total')); ?>,
            backgroundColor: '#10b981',
            borderRadius: 8,
            barThickness: 30
        }]
    };

    // Render Source Chart (Pie)
    if(document.getElementById('sourceChart')) {
        new Chart(document.getElementById('sourceChart'), {
            type: 'doughnut',
            data: sourceData,
            options: {
                responsive: true,
                cutout: '60%',
                plugins: { legend: { display: false } }
            }
        });
    }

    // Render Type Chart (Bar)
    if(document.getElementById('typeChart')) {
        new Chart(document.getElementById('typeChart'), {
            type: 'bar',
            data: typeData,
            options: {
                responsive: true,
                plugins: { legend: { display: false } },
                scales: {
                    y: { beginAtZero: true, grid: { borderDash: [4, 4] } },
                    x: { grid: { display: false } }
                }
            }
        });
    }
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\Users\HP\Downloads\ensan\System.Ensan-main\System.Ensan-main\resources\views/revenues/index.blade.php ENDPATH**/ ?>