<style>
    /* Robust Solid Dark Theme for Project Modals */
    .modal-premium-dark {
        background-color: #0f172a !important; /* Solid Slate 900 */
        background-image: none !important;
        opacity: 1 !important;
        border: 1px solid rgba(255, 255, 255, 0.15) !important;
        box-shadow: 0 25px 50px -12px rgba(0, 0, 0, 0.8) !important;
        backdrop-filter: none !important;
        -webkit-backdrop-filter: none !important;
    }
    .modal-premium-dark .modal-header, 
    .modal-premium-dark .modal-footer,
    .bg-slate-800 {
        background-color: #1e293b !important; /* Solid Slate 800 */
    }
    .modal-premium-dark .modal-body {
        background-color: #0f172a !important;
    }
    .modal-premium-dark .nav-pills .nav-link {
        color: #94a3b8;
        border-radius: 12px;
        transition: all 0.3s ease;
    }
    .modal-premium-dark .nav-pills .nav-link.active {
        background: #3b82f6 !important;
        color: white;
    }
    .modal-premium-dark .form-control,
    .modal-premium-dark .form-select,
    .modal-premium-dark textarea {
        background-color: #1e293b !important; /* Solid Slate 800 */
        border-color: #334155 !important;
        color: #f8fafc !important;
        opacity: 1 !important;
    }
    .modal-premium-dark .form-control:focus {
        border-color: #3b82f6 !important;
        box-shadow: 0 0 0 2px rgba(59, 130, 246, 0.2) !important;
    }
</style>



<div class="modal fade" id="editProjectModal<?php echo e($project->id); ?>" tabindex="-1" aria-hidden="true" style="z-index: 2050;">
    <div class="modal-dialog modal-xl modal-dialog-centered">
        <form action="<?php echo e(route('website.projects.update', $project->id)); ?>" method="POST" enctype="multipart/form-data" class="modal-content modal-premium-dark border-0 text-white">
            <?php echo csrf_field(); ?>
            <?php echo method_field('PUT'); ?>
            <div class="modal-header border-bottom border-white border-opacity-10 bg-slate-800">
                <h5 class="modal-title fw-bold"><i class="bi bi-pencil-square me-2 text-warning"></i> تعديل المشروع: <?php echo e($project->name); ?></h5>
                <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"></button>
            </div>
            
            <div class="modal-body p-0">
                <div class="row g-0">
                    
                    <div class="col-md-3 border-end border-white border-opacity-10 bg-slate-800 p-3">
                        <div class="nav flex-column nav-pills" id="v-pills-tab-edit-<?php echo e($project->id); ?>" role="tablist" aria-orientation="vertical">
                            <button class="nav-link active mb-2 text-start" id="tab-basic-tab-<?php echo e($project->id); ?>" data-bs-toggle="pill" data-bs-target="#tab-basic-<?php echo e($project->id); ?>" type="button" role="tab"><i class="bi bi-info-circle me-2"></i> المعلومات الأساسية</button>
                            <button class="nav-link mb-2 text-start" id="tab-media-tab-<?php echo e($project->id); ?>" data-bs-toggle="pill" data-bs-target="#tab-media-<?php echo e($project->id); ?>" type="button" role="tab"><i class="bi bi-palette me-2"></i> الهوية والألوان</button>
                            <button class="nav-link mb-2 text-start" id="tab-dynamic-tab-<?php echo e($project->id); ?>" data-bs-toggle="pill" data-bs-target="#tab-dynamic-<?php echo e($project->id); ?>" type="button" role="tab"><i class="bi bi-grid-3x3-gap me-2"></i> المزايا والإحصائيات</button>
                            <button class="nav-link mb-2 text-start" id="tab-action-tab-<?php echo e($project->id); ?>" data-bs-toggle="pill" data-bs-target="#tab-action-<?php echo e($project->id); ?>" type="button" role="tab"><i class="bi bi-link-45deg me-2"></i> الروابط والإجراءات</button>
                        </div>
                    </div>

                    
                    <div class="col-md-9 p-4 bg-slate-900" style="max-height: 70vh; overflow-y: auto; background-color: #0f172a !important;">
                        <div class="tab-content" id="v-pills-tabContent-<?php echo e($project->id); ?>">
                            
                            
                            <div class="tab-pane fade show active" id="tab-basic-<?php echo e($project->id); ?>" role="tabpanel">
                                <h6 class="fw-bold mb-3 border-bottom border-white border-opacity-10 pb-2">المعلومات الأساسية</h6>
                                <div class="row g-3">
                                    <div class="col-md-12">
                                        <div class="p-3 rounded-4 bg-slate-800 border border-info border-opacity-30 mb-3" style="background-color: #1e293b !important;">
                                            <div class="d-flex align-items-center justify-content-between mb-3">
                                                <h6 class="x-small fw-bold text-info mb-0"><i class="bi bi-star-fill me-1"></i> الشارة المميزة (Badge) - التي في الصورة</h6>
                                                <div class="form-check form-switch mb-0">
                                                    <input class="form-check-input" type="checkbox" name="show_badge" <?php echo e($project->show_badge ? 'checked' : ''); ?> id="showBadgeCheck<?php echo e($project->id); ?>">
                                                    <label class="form-check-label fw-bold x-small" for="showBadgeCheck<?php echo e($project->id); ?>">تفعيل ظهور الشارة</label>
                                                </div>
                                            </div>
                                            <div class="row g-2">
                                                <div class="col-md-6">
                                                    <label class="form-label x-small fw-bold text-slate-400">نص الشارة (مثلاً: مميز)</label>
                                                    <input type="text" name="badge_text" class="form-control form-control-sm bg-dark text-white border-secondary shadow-none" value="<?php echo e($project->badge_text); ?>" placeholder="مثلاً: مميز">
                                                </div>
                                                <div class="col-md-6">
                                                    <label class="form-label x-small fw-bold text-slate-400">أيقونة الشارة (اختر من المعرض)</label>
                                                    <input type="file" name="badge_icon_file" class="form-control form-control-sm bg-dark text-white border-secondary shadow-none">
                                                </div>
                                            </div>
                                        </div>
                                    </div>

                                    <div class="col-md-12">
                                        <label class="form-label x-small fw-bold text-slate-400">اسم المشروع (العنوان)</label>
                                        <input type="text" name="name" class="form-control bg-dark text-white border-secondary" required value="<?php echo e($project->name); ?>">
                                    </div>
                                    <div class="col-md-6">
                                        <label class="form-label x-small fw-bold text-slate-400">التصنيف الرئيسي (Category)</label>
                                        <input type="text" name="category" class="form-control bg-dark text-white border-secondary" value="<?php echo e($project->category); ?>">
                                    </div>

                                    <div class="col-md-6">
                                        <label class="form-label x-small fw-bold text-slate-400">تفاصيل الكفالة (مثلاً: 500 ريال شهرياً)</label>
                                        <input type="text" name="sponsorship_details" class="form-control bg-dark text-white border-secondary shadow-none" value="<?php echo e($project->sponsorship_details); ?>">
                                    </div>
                                    <div class="col-12">
                                        <label class="form-label x-small fw-bold text-slate-400">وصف مختصر (حتى سطرين)</label>
                                        <textarea name="short_description" class="form-control bg-dark text-white border-secondary" rows="2"><?php echo e($project->short_description); ?></textarea>
                                    </div>
                                    <div class="col-12">
                                        <label class="form-label x-small fw-bold text-slate-400">الوصف الكامل (محتوى الصفحة)</label>
                                        <textarea name="website_content" class="form-control bg-dark text-white border-secondary" rows="4"><?php echo e($project->website_content); ?></textarea>
                                    </div>
                                </div>
                            </div>

                            
                            <div class="tab-pane fade" id="tab-media-<?php echo e($project->id); ?>" role="tabpanel">
                                <h6 class="fw-bold mb-3 border-bottom border-white border-opacity-10 pb-2">الهوية البصرية والألوان</h6>
                                <div class="row g-3">
                                    <div class="col-md-6">
                                        <label class="form-label x-small fw-bold text-slate-400">صورة الخلفية (Cover Image)</label>
                                        <?php if($project->image_path): ?>
                                            <div class="mb-2"><img src="<?php echo e(asset('storage/' . $project->image_path)); ?>" class="rounded" style="height: 50px;"></div>
                                        <?php endif; ?>
                                        <input type="file" name="image" class="form-control bg-dark text-white border-secondary" accept="image/*">
                                    </div>
                                    <div class="col-md-6">
                                        <label class="form-label x-small fw-bold text-slate-400">أيقونة المشروع (Icon)</label>
                                        <?php if($project->icon_path): ?>
                                            <div class="mb-2"><img src="<?php echo e(asset('storage/' . $project->icon_path)); ?>" class="rounded" style="height: 50px;"></div>
                                        <?php endif; ?>
                                        <input type="file" name="icon" class="form-control bg-dark text-white border-secondary" accept="image/*">
                                    </div>
                                    <div class="col-md-12 mt-4">
                                        <h6 class="x-small fw-bold text-info mb-3"><i class="bi bi-palette me-1"></i> ثيم الألوان (Theme Colors)</h6>
                                    </div>
                                    <div class="col-md-3">
                                        <label class="form-label x-small fw-bold text-slate-400">اللون الأساسي</label>
                                        <input type="color" name="theme_colors[primaryColor]" class="form-control form-control-sm bg-dark border-secondary h-auto" value="<?php echo e($project->theme_colors['primaryColor'] ?? '#0d6efd'); ?>">
                                    </div>
                                    <div class="col-md-3">
                                        <label class="form-label x-small fw-bold text-slate-400">لون شفاف (Tint)</label>
                                        <input type="color" name="theme_colors[lightTint]" class="form-control form-control-sm bg-dark border-secondary h-auto" value="<?php echo e($project->theme_colors['lightTint'] ?? '#e7f1ff'); ?>">
                                    </div>
                                    <div class="col-md-3">
                                        <label class="form-label x-small fw-bold text-slate-400">لون الإطار</label>
                                        <input type="color" name="theme_colors[borderColor]" class="form-control form-control-sm bg-dark border-secondary h-auto" value="<?php echo e($project->theme_colors['borderColor'] ?? '#cfe2ff'); ?>">
                                    </div>
                                    <div class="col-md-3">
                                        <label class="form-label x-small fw-bold text-slate-400">لون الأيقونة</label>
                                        <input type="color" name="theme_colors[iconColor]" class="form-control form-control-sm bg-dark border-secondary h-auto" value="<?php echo e($project->theme_colors['iconColor'] ?? '#0d6efd'); ?>">
                                    </div>
                                </div>
                            </div>

                            
                            <div class="tab-pane fade" id="tab-dynamic-<?php echo e($project->id); ?>" role="tabpanel">
                                <div class="row g-4">
                                    
                                    <div class="col-12">
                                        <h6 class="fw-bold mb-3 border-bottom border-white border-opacity-10 pb-2">قائمة المزايا / الخدمات (Pills)</h6>
                                        <div id="features-container-<?php echo e($project->id); ?>" data-count="<?php echo e(count($project->features ?? [])); ?>">
                                            <?php $fIdx = 0; ?>
                                            <?php $__currentLoopData = ($project->features ?? []); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $feature): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <div class="row g-2 mb-2 feature-row-edit align-items-center">
                                                    <div class="col-md-4">
                                                        <input type="text" name="features[<?php echo e($fIdx); ?>][text]" class="form-control form-control-sm bg-dark text-white border-secondary" value="<?php echo e($feature['text'] ?? ''); ?>">
                                                    </div>
                                                    <div class="col-md-6">
                                                        <div class="input-group input-group-sm">
                                                            <?php if(!empty($feature['icon'])): ?>
                                                                <span class="input-group-text bg-slate-800 border-secondary"><img src="<?php echo e(asset('storage/' . $feature['icon'])); ?>" style="width: 16px;"></span>
                                                            <?php endif; ?>
                                                            <input type="file" name="features[<?php echo e($fIdx); ?>][icon_file]" class="form-control bg-dark text-white border-secondary">
                                                            <input type="hidden" name="features[<?php echo e($fIdx); ?>][existing_icon]" value="<?php echo e($feature['icon'] ?? ''); ?>">
                                                        </div>
                                                    </div>
                                                    <div class="col-md-2">
                                                        <button type="button" class="btn btn-sm btn-outline-danger w-100 py-1" onclick="this.closest('.feature-row-edit').remove()"><i class="bi bi-trash"></i></button>
                                                    </div>
                                                </div>
                                                <?php $fIdx++; ?>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </div>
                                        <button type="button" class="btn btn-sm btn-outline-info mt-2" onclick="addFeatureRowEdit(<?php echo e($project->id); ?>)"><i class="bi bi-plus-lg"></i> إضافة ميزة</button>
                                    </div>

                                    
                                    <div class="col-12 mt-4">
                                        <h6 class="fw-bold mb-3 border-bottom border-white border-opacity-10 pb-2">قسم الإحصائيات</h6>
                                        <div id="stats-container-<?php echo e($project->id); ?>" data-count="<?php echo e(count($project->stats ?? [])); ?>">
                                            <?php $sIdx = 0; ?>
                                            <?php $__currentLoopData = ($project->stats ?? []); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $stat): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <div class="row g-2 mb-3 stat-row-edit align-items-center">
                                                    <div class="col-md-3">
                                                        <input type="text" name="stats[<?php echo e($sIdx); ?>][value]" class="form-control form-control-sm bg-dark text-white border-secondary" value="<?php echo e($stat['value'] ?? ''); ?>">
                                                    </div>
                                                    <div class="col-md-3">
                                                        <input type="text" name="stats[<?php echo e($sIdx); ?>][label]" class="form-control form-control-sm bg-dark text-white border-secondary" value="<?php echo e($stat['label'] ?? ''); ?>">
                                                    </div>
                                                    <div class="col-md-5">
                                                        <div class="input-group input-group-sm">
                                                            <?php if(!empty($stat['icon'])): ?>
                                                                <span class="input-group-text bg-slate-800 border-secondary"><img src="<?php echo e(asset('storage/' . $stat['icon'])); ?>" style="width: 16px;"></span>
                                                            <?php endif; ?>
                                                            <input type="file" name="stats[<?php echo e($sIdx); ?>][icon_file]" class="form-control bg-dark text-white border-secondary">
                                                            <input type="hidden" name="stats[<?php echo e($sIdx); ?>][existing_icon]" value="<?php echo e($stat['icon'] ?? ''); ?>">
                                                        </div>
                                                    </div>
                                                    <div class="col-md-1">
                                                        <button type="button" class="btn btn-sm btn-outline-danger w-100 py-1" onclick="this.closest('.stat-row-edit').remove()"><i class="bi bi-trash"></i></button>
                                                    </div>
                                                </div>
                                                <?php $sIdx++; ?>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </div>
                                        <button type="button" class="btn btn-sm btn-outline-warning mt-2" onclick="addStatRowEdit(<?php echo e($project->id); ?>)"><i class="bi bi-plus-lg"></i> إضافة إحصائية</button>
                                    </div>
                                </div>
                            </div>

                            
                            <div class="tab-pane fade" id="tab-action-<?php echo e($project->id); ?>" role="tabpanel">
                                <h6 class="fw-bold mb-3 border-bottom border-white border-opacity-10 pb-2">الإجراءات والروابط الذكية</h6>
                                <div class="row g-3">
                                    <div class="col-md-12">
                                        <div class="alert alert-info bg-info bg-opacity-10 border-info border-opacity-20 text-info x-small mb-0 py-2">
                                            <i class="bi bi-info-circle me-2"></i> الزر ثابت بنص <strong>"تبرع الآن"</strong> ورابط <strong>"صفحة التبرع"</strong>.
                                            <input type="hidden" name="action_text" value="تبرع الان">
                                            <input type="hidden" name="action_url" value="http://127.0.0.1:4200/donate">
                                        </div>
                                    </div>
                                    <div class="col-md-12">
                                        <div class="p-3 rounded-4 bg-slate-800 border border-warning border-opacity-30 mb-3" style="background-color: #1e293b !important;">
                                            <div class="row g-2 align-items-center">
                                                <div class="col-md-6">
                                                    <label class="form-label x-small fw-bold text-slate-400">أيقونة الزر (اختر من المعرض)</label>
                                                    <input type="file" name="action_icon_file" class="form-control form-control-sm bg-dark text-white border-secondary" accept="image/*"
                                                        onchange="document.getElementById('editActionIconPreview<?php echo e($project->id); ?>').src = window.URL.createObjectURL(this.files[0]); document.getElementById('editActionIconPreview<?php echo e($project->id); ?>').classList.remove('d-none');">
                                                </div>
                                                <div class="col-md-2 mt-4 text-center">
                                                    <?php if($project->action_icon): ?>
                                                        <img src="<?php echo e(asset('storage/' . $project->action_icon)); ?>" id="editActionIconPreview<?php echo e($project->id); ?>" class="rounded bg-secondary bg-opacity-25" style="width: 35px; height: 35px; object-fit: contain;">
                                                    <?php else: ?>
                                                        <img src="" id="editActionIconPreview<?php echo e($project->id); ?>" class="rounded bg-secondary bg-opacity-25 d-none" style="width: 35px; height: 35px; object-fit: contain;">
                                                    <?php endif; ?>
                                                </div>
                                                <div class="col-md-4">
                                                    <div class="form-check form-switch mb-0 mt-4 ms-3">
                                                        <input class="form-check-input" type="checkbox" name="is_visible" <?php echo e($project->is_visible ? 'checked' : ''); ?> id="isVisibleCheck<?php echo e($project->id); ?>">
                                                        <label class="form-check-label fw-bold x-small" for="isVisibleCheck<?php echo e($project->id); ?>">المشروع مرئي للعامة</label>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>

                        </div>
                    </div>
                </div>
            </div>

            <div class="modal-footer border-top border-white border-opacity-10 bg-slate-800">
                <button type="button" class="btn btn-sm btn-outline-light rounded-pill px-4" data-bs-dismiss="modal">إلغاء</button>
                <button type="submit" class="btn btn-sm btn-warning text-dark rounded-pill px-5 shadow-sm fw-bold">تحديث المشروع</button>
            </div>
        </form>
    </div>
</div>


<script>
    window.editFeatureIdxs = window.editFeatureIdxs || {};
    window.editStatIdxs = window.editStatIdxs || {};

    function addFeatureRowEdit(projId) {
        const container = document.getElementById('features-container-' + projId);
        if (!window.editFeatureIdxs[projId]) {
            window.editFeatureIdxs[projId] = parseInt(container.getAttribute('data-count')) || 0;
        }
        const container = document.getElementById('features-container-' + projId);
        const row = document.createElement('div');
        row.className = 'row g-2 mb-2 feature-row-edit align-items-center';
        row.innerHTML = `
            <div class="col-md-4">
                <input type="text" name="features[${window.editFeatureIdxs[projId]}][text]" class="form-control form-control-sm bg-dark text-white border-secondary" placeholder="نص الميزة">
            </div>
            <div class="col-md-6">
                <div class="input-group input-group-sm">
                    <input type="file" name="features[${window.editFeatureIdxs[projId]}][icon_file]" class="form-control bg-dark text-white border-secondary">
                </div>
            </div>
            <div class="col-md-2">
                <button type="button" class="btn btn-sm btn-outline-danger w-100 py-1" onclick="this.closest('.feature-row-edit').remove()"><i class="bi bi-trash"></i></button>
            </div>
        `;
        container.appendChild(row);
        window.editFeatureIdxs[projId]++;
    }

    function addStatRowEdit(projId) {
        const container = document.getElementById('stats-container-' + projId);
        if (!window.editStatIdxs[projId]) {
            window.editStatIdxs[projId] = parseInt(container.getAttribute('data-count')) || 0;
        }
        const container = document.getElementById('stats-container-' + projId);
        const row = document.createElement('div');
        row.className = 'row g-2 mb-3 stat-row-edit align-items-center';
        row.innerHTML = `
            <div class="col-md-3">
                <input type="text" name="stats[${window.editStatIdxs[projId]}][value]" class="form-control form-control-sm bg-dark text-white border-secondary" placeholder="القيمة">
            </div>
            <div class="col-md-3">
                <input type="text" name="stats[${window.editStatIdxs[projId]}][label]" class="form-control form-control-sm bg-dark text-white border-secondary" placeholder="الوصف">
            </div>
            <div class="col-md-5">
                <div class="input-group input-group-sm">
                    <input type="file" name="stats[${window.editStatIdxs[projId]}][icon_file]" class="form-control bg-dark text-white border-secondary">
                </div>
            </div>
            <div class="col-md-1">
                <button type="button" class="btn btn-sm btn-outline-danger w-100 py-1" onclick="this.closest('.stat-row-edit').remove()"><i class="bi bi-trash"></i></button>
            </div>
        `;
        container.appendChild(row);
        window.editStatIdxs[projId]++;
    }
</script>
<?php /**PATH C:\Users\HP\Downloads\ensan\System.Ensan-main\System.Ensan-main\resources\views/website/edit_project_modal.blade.php ENDPATH**/ ?>