<?php $__env->startSection('content'); ?>
<link href="https://fonts.googleapis.com/css2?family=Outfit:wght@300;400;600;700&family=Tajawal:wght@300;400;500;700;800&display=swap" rel="stylesheet">

<div class="volunteer-requests-page">
    
    <div class="premium-hero-sleek">
        <div class="hero-bg-visuals">
            <div class="glow-orb-1"></div>
            <div class="glow-orb-2"></div>
            <div class="noise-overlay"></div>
        </div>
        
        <div class="hero-content-wrapper container-fluid">
            <div class="row align-items-center">
                <div class="col-lg-8 animate-reveal-right text-end">
                    <nav aria-label="breadcrumb" class="mb-4 d-flex justify-content-end">
                        <ol class="breadcrumb mb-0">
                            <li class="breadcrumb-item"><a href="<?php echo e(route('dashboard.index')); ?>" class="text-white-50 decoration-none">لوحة التحكم</a></li>
                            <li class="breadcrumb-item active text-white" aria-current="page">تطوع معنا</li>
                        </ol>
                    </nav>
                    <div class="d-flex align-items-center justify-content-end gap-3 mb-3">
                        <div class="badge-glass-premium">
                            <i class="bi bi-person-heart me-2"></i> بناء مجتمع إنسان المعطاء
                        </div>
                    </div>
                    <h1 class="display-3 fw-800 text-white mb-3 text-end">تطوع معنا</h1>
                    <p class="lead text-white-50 mb-0 max-w-600 ms-auto me-0 text-end">
                        <?php echo e($settings['volunteer_description'] ?? 'نستقبل المتطوعين في مجالات مختلفة: تنظيم الحملات، التوزيع الميداني، التصميم، التسويق الرقمي، والمزيد.'); ?>

                    </p>
                </div>
                <div class="col-lg-4 text-start mt-4 mt-lg-0 animate-reveal-left">
                    
                </div>
            </div>
        </div>
    </div>

    
    <div class="container-fluid py-5 content-shift-up">
        <div class="row g-4">
            <?php $__empty_1 = true; $__currentLoopData = $requests; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $request): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
            <div class="col-md-6 col-lg-4 col-xl-3">
                <div class="request-card-premium animate-up" style="animation-delay: <?php echo e($loop->index * 0.05); ?>s">
                    <div class="card-status-pill">
                        <?php
                            $statusMap = [
                                'new' => ['label' => 'طلب جديد', 'class' => 'status-new'],
                                'contacted' => ['label' => 'تم التواصل', 'class' => 'status-contacted'],
                                'accepted' => ['label' => 'مقبول', 'class' => 'status-accepted'],
                                'rejected' => ['label' => 'مرفوض', 'class' => 'status-rejected'],
                            ];
                            $currStatus = $statusMap[$request->status] ?? ['label' => $request->status, 'class' => 'status-new'];
                        ?>
                        <span class="badge-status <?php echo e($currStatus['class']); ?>">
                            <?php echo e($currStatus['label']); ?>

                        </span>
                    </div>

                    <div class="card-top-vibe">
                        <div class="user-avatar-premium shadow-xl">
                            <div class="avatar-ring"></div>
                            <span class="avatar-initials"><?php echo e(mb_substr($request->name, 0, 1)); ?></span>
                        </div>
                        <div class="user-main-info">
                            <h6 class="fw-bold mb-1 text-white"><?php echo e($request->name); ?></h6>
                            <p class="x-small text-slate-400 mb-0">
                                <i class="bi bi-calendar-event me-1"></i>
                                <?php echo e($request->created_at->translatedFormat('d M Y')); ?>

                            </p>
                        </div>
                    </div>

                    <div class="card-mid-vibe mt-4">
                        <div class="interest-pill-lux mb-3">
                            <i class="bi bi-lightning-charge-fill me-2 text-indigo-400"></i>
                            <span><?php echo e($request->area_of_interest ?? 'رغبة عامة'); ?></span>
                        </div>
                        
                        <div class="quick-contact-grid">
                            <div class="contact-item-lux">
                                <i class="bi bi-phone"></i>
                                <span><?php echo e($request->phone); ?></span>
                            </div>
                            <div class="contact-item-lux">
                                <i class="bi bi-envelope"></i>
                                <span class="text-break"><?php echo e($request->email); ?></span>
                            </div>
                        </div>
                    </div>

                    <div class="card-bottom-vibe mt-4">
                        <div class="d-flex gap-2">
                            <?php if($request->cv_path): ?>
                                <a href="<?php echo e(asset('storage/' . $request->cv_path)); ?>" target="_blank" class="btn btn-glass-dark flex-grow-1 py-2">
                                    <i class="bi bi-file-earmark-pdf-fill text-danger me-1"></i> CV
                                </a>
                            <?php endif; ?>
                            <button class="btn btn-primary-sleek <?php echo e($request->cv_path ? 'w-auto' : 'flex-grow-1'); ?> px-4 py-2" data-bs-toggle="modal" data-bs-target="#viewReq<?php echo e($request->id); ?>">
                                <i class="bi bi-eye-fill me-1"></i> عرض الطلب
                            </button>
                        </div>
                        <div class="mt-3 text-center">
                            <form action="<?php echo e(route('website.volunteer-requests.destroy', $request)); ?>" method="POST" class="d-inline">
                                <?php echo csrf_field(); ?> <?php echo method_field('DELETE'); ?>
                                <button type="submit" class="btn btn-link-danger x-small text-decoration-none" onclick="return confirm('هل أنت متأكد من حذف هذا الطلب نهائياً؟')">
                                    <i class="bi bi-trash3 me-1"></i> حذف الطلب نهائياً
                                </button>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
            <div class="col-12">
                <div class="empty-state-card-lux animate-up mt-5">
                    <div class="empty-visual-wrapper">
                        <div class="glow-pulse"></div>
                        <i class="bi bi-mailbox2-flag empty-icon-vibe"></i>
                    </div>
                    <h3 class="fw-bold text-white mt-4">صندوق الطلبات فارغ</h3>
                    <p class="text-slate-400 max-w-400 mx-auto">لم تصلنا أي طلبات تطوع جديدة حالياً. سيتم إخطارك فور وصول أي طلب جديد عبر النظام.</p>
                </div>
            </div>
            <?php endif; ?>
        </div>
    </div>
</div>


<?php $__currentLoopData = $requests; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $request): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
<div class="modal fade" id="viewReq<?php echo e($request->id); ?>" tabindex="-1">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content premium-modal-dark border-0">
            <div class="modal-header border-0 pb-0 p-4">
                <h5 class="modal-title fw-bold text-white">تفاصيل طلب التطوع</h5>
                <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body p-4 pt-2">
                <div class="info-strip-premium mb-4">
                    <div class="strip-avatar bg-indigo-600">
                        <i class="bi bi-person-fill"></i>
                    </div>
                    <div>
                        <h6 class="fw-bold mb-0 text-white"><?php echo e($request->name); ?></h6>
                        <p class="mb-0 x-small text-slate-400">الاسم الرباعي</p>
                    </div>
                </div>

                <div class="row g-3 mb-4">
                    <div class="col-md-6">
                        <div class="detail-box-lux h-100">
                            <label class="detail-label-sleek">الرقم القومي (14 رقم)</label>
                            <div class="detail-content-sleek"><?php echo e($request->national_id ?? '-'); ?></div>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="detail-box-lux h-100">
                            <label class="detail-label-sleek">تاريخ الميلاد (mm/dd/yyyy)</label>
                            <div class="detail-content-sleek"><?php echo e($request->birth_date ?? '-'); ?></div>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="detail-box-lux h-100">
                            <label class="detail-label-sleek">النوع</label>
                            <div class="detail-content-sleek">
                                <?php echo e($request->gender == 'male' ? 'ذكر' : ($request->gender == 'female' ? 'أنثى' : ($request->gender ?? '-'))); ?>

                            </div>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="detail-box-lux h-100">
                            <label class="detail-label-sleek">رقم التليفون (01xxxxxxxxx)</label>
                            <div class="detail-content-sleek"><?php echo e($request->phone ?? '-'); ?></div>
                        </div>
                    </div>
                     <div class="col-md-4">
                        <div class="detail-box-lux h-100">
                            <label class="detail-label-sleek">البريد الإلكتروني</label>
                            <div class="detail-content-sleek text-break"><?php echo e($request->email ?? '-'); ?></div>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="detail-box-lux h-100">
                            <label class="detail-label-sleek">العنوان الدائم (مثال: كفر الشيخ - مدينة كفر الشيخ)</label>
                            <div class="detail-content-sleek"><?php echo e($request->address ?? '-'); ?></div>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="detail-box-lux h-100">
                            <label class="detail-label-sleek">العنوان الحالي "في حالة الطلبة المغتربين" (عنوان السكن الحالي)</label>
                            <div class="detail-content-sleek"><?php echo e($request->current_address ?? '-'); ?></div>
                        </div>
                    </div>
                </div>

                <h6 class="fw-bold text-white mb-3 ps-2 border-start border-4 border-indigo-500">معلومات الدراسة والعمل</h6>
                <div class="row g-3 mb-4">
                    <div class="col-md-4">
                        <div class="detail-box-lux h-100">
                            <label class="detail-label-sleek">المؤهل / المرحلة الدراسية</label>
                            <div class="detail-content-sleek">
                                <?php echo e($request->education_level == 'student' ? 'طالب' : ($request->education_level == 'graduated' ? 'خريج' : ($request->education_level ?? '-'))); ?>

                            </div>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="detail-box-lux h-100">
                            <label class="detail-label-sleek">الكلية (اسم الكلية)</label>
                            <div class="detail-content-sleek"><?php echo e($request->faculty ?? '-'); ?></div>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="detail-box-lux h-100">
                            <label class="detail-label-sleek">الجامعة (اسم الجامعة)</label>
                            <div class="detail-content-sleek"><?php echo e($request->university ?? '-'); ?></div>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="detail-box-lux h-100">
                            <label class="detail-label-sleek">الوظيفة الحالية (إن وجد)</label>
                            <div class="detail-content-sleek"><?php echo e($request->current_job ?? '-'); ?></div>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="detail-box-lux h-100">
                            <label class="detail-label-sleek">سبق واشتركت في أعمال تطوعية</label>
                            <div class="detail-content-sleek">
                                <?php echo e(($request->previous_experience == '1' || strtolower($request->previous_experience) == 'yes') ? 'نعم' : (($request->previous_experience == '0' || strtolower($request->previous_experience) == 'no') ? 'لا' : ($request->previous_experience ?? '-'))); ?>

                            </div>
                        </div>
                    </div>
                </div>

                <h6 class="fw-bold text-white mb-3 ps-2 border-start border-4 border-indigo-500">بيانات التطوع</h6>
                <div class="row g-3 mb-4">
                     <div class="col-md-12">
                        <div class="detail-box-lux">
                            <label class="detail-label-sleek">ما المهارات والاهتمامات التي تمتلكها؟ (مثال: تصوير، تصميم، كتابة، تنظيم...)</label>
                            <div class="detail-content-sleek">
                                <div class="mb-2"><strong class="text-indigo-300">مجال الاهتمام:</strong> <?php echo e($request->area_of_interest ?? '-'); ?></div>
                                <div><strong class="text-indigo-300">المهارات:</strong> <?php echo e($request->skills ?? '-'); ?></div>
                            </div>
                        </div>
                    </div>
                     <div class="col-md-12">
                        <div class="detail-box-lux">
                            <label class="detail-label-sleek">لماذا ترغب في التطوع مع مؤسسة إنسان؟ (اكتب سبب رغبتك باختصار)</label>
                            <div class="detail-content-sleek"><?php echo e($request->goal ?? '-'); ?></div>
                        </div>
                    </div>
                     <div class="col-md-6">
                        <div class="detail-box-lux h-100">
                            <label class="detail-label-sleek">متوقع إنسان تضفلك إيه؟ (توقعاتك من التطوع)</label>
                            <div class="detail-content-sleek"><?php echo e($request->expectations ?? '-'); ?></div>
                        </div>
                    </div>
                     <div class="col-md-6">
                        <div class="detail-box-lux h-100">
                            <label class="detail-label-sleek">عدد ساعات التطوع الأسبوعية المتاحة</label>
                            <div class="detail-content-sleek"><?php echo e($request->volunteer_hours ?? '-'); ?></div>
                        </div>
                    </div>
                </div>

                <div class="detail-box-lux mb-4">
                    <label class="detail-label-sleek">الرسالة الدافعية / ملاحظات المتقدم</label>
                    <div class="detail-content-sleek">
                        <?php echo e($request->message ?? 'لا يوجد نص رسالة مرفق مع هذا الطلب.'); ?>

                    </div>
                </div>
                
                <div class="mt-4 p-3 rounded-4 bg-dark bg-opacity-50 border border-white border-opacity-10">
                    <h6 class="fw-bold text-white mb-3">تحديث حالة الطلب</h6>
                    <form action="<?php echo e(route('website.volunteer-requests.status', $request)); ?>" method="POST" class="d-flex gap-2">
                        <?php echo csrf_field(); ?> <?php echo method_field('PATCH'); ?>
                        <select name="status" class="form-select bg-dark text-white border-secondary rounded-pill px-3">
                            <option value="new" <?php echo e($request->status == 'new' ? 'selected' : ''); ?>>طلب جديد</option>
                            <option value="contacted" <?php echo e($request->status == 'contacted' ? 'selected' : ''); ?>>تم التواصل</option>
                            <option value="accepted" <?php echo e($request->status == 'accepted' ? 'selected' : ''); ?>>مقبول</option>
                            <option value="rejected" <?php echo e($request->status == 'rejected' ? 'selected' : ''); ?>>مرفوض</option>
                        </select>
                        <button type="submit" class="btn btn-primary-sleek px-4 rounded-pill">حفظ</button>
                    </form>
                </div>

                <div class="d-grid mt-4">
                    <button type="button" class="btn btn-glass-indigo py-3 rounded-pill fw-bold" data-bs-dismiss="modal">إغلاق المعاينة</button>
                </div>
            </div>
        </div>
    </div>
</div>
<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

    
    <div class="container-fluid pb-5">
        <div class="row">
            <div class="col-12">
                <form action="<?php echo e(route('website.volunteer-content.update')); ?>" method="POST" enctype="multipart/form-data">
                    <?php echo csrf_field(); ?>
                    <div class="premium-card-dark animate-up">
                        <div class="card-header-lux d-flex justify-content-between align-items-center">
                            <div class="d-flex align-items-center gap-3">
                                <div class="header-icon-box-lux bg-indigo-500">
                                    <i class="bi bi-layout-text-window-reverse"></i>
                                </div>
                                <div>
                                    <h5 class="fw-bold mb-0">تخصيص واجهة تطوع معنا</h5>
                                    <p class="text-indigo-200 x-small mb-0">تحديث المحتوى المرئي والإحصائيات لواجهة الموقع</p>
                                </div>
                            </div>
                            <button type="submit" class="btn btn-indigo-solid py-2 px-4 rounded-pill fw-bold shadow-indigo">
                                <i class="bi bi-check2-all me-2"></i> حفظ التعديلات
                            </button>
                        </div>
                        <div class="card-body-lux p-4 p-md-5">
                            <div class="row g-4">
                                <div class="col-md-7">
                                    <div class="form-group-lux mb-4">
                                        <label class="label-lux">عنوان الهيرو الرئيسي</label>
                                        <input type="text" name="volunteer_title" class="field-lux" value="<?php echo e($settings['volunteer_title'] ?? 'تطوع معنا وكن جزءاً من التغيير الجامد'); ?>">
                                    </div>
                                    <div class="form-group-lux mb-4">
                                        <label class="label-lux">نص الوصف</label>
                                        <textarea name="volunteer_description" class="field-lux scroll-thin" rows="3"><?php echo e($settings['volunteer_description'] ?? 'نستقبل المتطوعين في مجالات مختلفة: تنظيم الحملات، التوزيع الميداني، التصميم، التسويق الرقمي، والمزيد.'); ?></textarea>
                                    </div>
                                </div>

                                <div class="col-md-5">
                                    <label class="label-lux mb-3 text-center d-block">سلايدر الهيرو الحالية (صورة)</label>
                                    <div class="upload-zone-lux position-relative" id="heroDropZone">
                                        <input type="file" name="volunteer_hero_image" class="file-hidden" onchange="previewHero(this)">
                                        
                                        
                                        <?php if(!empty($settings['volunteer_hero_image']) && \Illuminate\Support\Str::contains($settings['volunteer_hero_image'], '/')): ?>
                                        <button type="button" class="btn btn-danger btn-sm rounded-circle position-absolute top-0 end-0 m-2 shadow-lg" 
                                                style="z-index: 20; width: 30px; height: 30px; padding: 0;"
                                                onclick="event.stopPropagation(); document.getElementById('delete_volunteer_hero_image').value='1'; this.closest('.upload-zone-lux').querySelector('.preview-area-lux').innerHTML='<div class=\'placeholder-vibe\'><i class=\'bi bi-cloud-arrow-up-fill fs-1 text-indigo-400\'></i><p class=\'small text-slate-400 mt-2\'>محذوف - حفظ للتنفيذ</p></div>'; this.remove();">
                                            <i class="bi bi-trash"></i>
                                        </button>
                                        <?php endif; ?>
                                        <input type="hidden" name="delete_volunteer_hero_image" id="delete_volunteer_hero_image" value="0">

                                        <div class="preview-area-lux">
                                            <?php if(!empty($settings['volunteer_hero_image']) && \Illuminate\Support\Str::contains($settings['volunteer_hero_image'], '/')): ?>
                                                <img src="<?php echo e(asset('storage/' . $settings['volunteer_hero_image'])); ?>" class="img-fluid rounded-4 shadow-lg" id="heroPrev2">
                                            <?php else: ?>
                                                <div class="placeholder-vibe">
                                                    <i class="bi bi-cloud-arrow-up-fill fs-1 text-indigo-400"></i>
                                                    <p class="small text-slate-400 mt-2">عوضاً عن ذلك، اختر صورة</p>
                                                </div>
                                            <?php endif; ?>
                                        </div>
                                    </div>
                                </div>

                                <div class="col-12">
                                    <label class="label-lux mb-3">صور السلايدر (بديلة للهيرو)</label>
                                    <div class="row g-3">
                                        <?php for($i = 1; $i <= 10; $i++): ?>
                                        <div class="col-md-4">
                                            <div class="upload-zone-lux position-relative" style="height: 150px;">
                                                <input type="file" name="volunteer_slider_<?php echo e($i); ?>" class="file-hidden" onchange="previewVolSlider(this, <?php echo e($i); ?>)">
                                                
                                                
                                                <?php if(!empty($settings["volunteer_slider_$i"]) && \Illuminate\Support\Str::contains($settings["volunteer_slider_$i"], '/')): ?>
                                                <button type="button" class="btn btn-danger btn-sm rounded-circle position-absolute top-0 end-0 m-2 shadow-lg" 
                                                        style="z-index: 20; width: 30px; height: 30px; padding: 0;"
                                                        onclick="event.stopPropagation(); document.getElementById('delete_volunteer_slider_<?php echo e($i); ?>').value='1'; this.closest('.upload-zone-lux').querySelector('.preview-area-lux').innerHTML='<div class=\'text-center\'><i class=\'bi bi-images fs-1 text-slate-600 mb-2\'></i><p class=\'x-small text-slate-500 mb-0\'>محذوف - حفظ لتنفيذ</p></div>'; this.remove();">
                                                    <i class="bi bi-trash"></i>
                                                </button>
                                                <?php endif; ?>
                                                <input type="hidden" name="delete_volunteer_slider_<?php echo e($i); ?>" id="delete_volunteer_slider_<?php echo e($i); ?>" value="0">

                                                <div class="preview-area-lux" id="volSliderPrev<?php echo e($i); ?>">
                                                    <?php if(!empty($settings["volunteer_slider_$i"]) && \Illuminate\Support\Str::contains($settings["volunteer_slider_$i"], '/')): ?>
                                                        <img src="<?php echo e(asset('storage/' . $settings["volunteer_slider_$i"])); ?>" class="img-fluid rounded-3 h-100 object-fit-cover">
                                                    <?php else: ?>
                                                        <div class="text-center">
                                                            <i class="bi bi-images fs-1 text-slate-600 mb-2"></i>
                                                            <p class="x-small text-slate-500 mb-0">صورة <?php echo e($i); ?></p>
                                                        </div>
                                                    <?php endif; ?>
                                                </div>
                                            </div>
                                        </div>
                                        <?php endfor; ?>
                                    </div>
                                </div>

                                <div class="col-12">
                                    <div class="stats-row-lux mt-2">
                                        <div class="form-group-lux">
                                            <label class="label-lux">متطوع مسجل</label>
                                            <input type="text" name="volunteer_stats_volunteers" class="field-lux text-center" value="<?php echo e($settings['volunteer_stats_volunteers'] ?? '42'); ?>">
                                        </div>
                                        <div class="form-group-lux">
                                            <label class="label-lux">ساعة تطوعية</label>
                                            <input type="text" name="volunteer_stats_hours" class="field-lux text-center" value="<?php echo e($settings['volunteer_stats_hours'] ?? '25,00+'); ?>">
                                        </div>
                                        <div class="form-group-lux">
                                            <label class="label-lux">مشروع تطوعي</label>
                                            <input type="text" name="volunteer_stats_projects" class="field-lux text-center" value="<?php echo e($settings['volunteer_stats_projects'] ?? '+50'); ?>">
                                        </div>
                                        <div class="form-group-lux">
                                            <label class="label-lux">عدد الفروع</label>
                                            <input type="text" name="volunteer_stats_branches" class="field-lux text-center" value="<?php echo e($settings['volunteer_stats_branches'] ?? '2'); ?>">
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>

<script>
function previewHero(input) {
    if (input.files && input.files[0]) {
        var reader = new FileReader();
        reader.onload = function(e) {
            const preview = document.getElementById('heroPrev2');
            if (preview) {
                preview.src = e.target.result;
            } else {
                // If it was a placeholder, replace the placeholder content
                const container = document.querySelector('.preview-area-lux');
                if (container)
                    container.innerHTML = `<img src="${e.target.result}" class="img-fluid rounded-4 shadow-lg" id="heroPrev2">`;
            }
        }
        reader.readAsDataURL(input.files[0]);
    }
}

function previewVolSlider(input, index) {
    if (input.files && input.files[0]) {
        var reader = new FileReader();
        reader.onload = function(e) {
            const container = document.getElementById('volSliderPrev' + index);
            container.innerHTML = `<img src="${e.target.result}" class="img-fluid rounded-3 h-100 object-fit-cover">`;
        }
        reader.readAsDataURL(input.files[0]);
    }
}
</script>

<style>
    :root {
        --indigo-primary: #6366f1;
        --indigo-dark: #4f46e5;
        --dark-bg: #0b0e14;
        --card-dark: #1a1f2e;
        --slate-900: #0f172a;
        --slate-800: #1e293b;
        --slate-400: #94a3b8;
        --slate-500: #64748b;
        --gold-premium: #fbbf24;
    }

    body {
        background-color: var(--dark-bg) !important;
        font-family: 'Tajawal', sans-serif;
        color: #f8fafc;
    }

    .volunteer-requests-page {
        min-height: 100vh;
    }

    /* Premium Hero Sleek */
    .premium-hero-sleek {
        position: relative;
        padding: 100px 0 120px;
        background: linear-gradient(135deg, #1e1b4b 0%, #312e81 100%);
        border-radius: 0 0 60px 60px;
        overflow: hidden;
        z-index: 10;
        box-shadow: 0 20px 50px rgba(0,0,0,0.3);
    }

    .hero-bg-visuals div { position: absolute; border-radius: 50%; filter: blur(100px); opacity: 0.4; pointer-events: none; }
    .glow-orb-1 { width: 400px; height: 400px; background: var(--indigo-primary); top: -100px; right: -50px; }
    .glow-orb-2 { width: 300px; height: 300px; background: #c084fc; bottom: -150px; left: -50px; }
    .noise-overlay { position: absolute; inset: 0; opacity: 0.05; background-image: url('data:image/svg+xml,...'); }

    .hero-content-wrapper { position: relative; z-index: 5; padding: 0 5%; }
    .badge-glass-premium { 
        background: rgba(255, 255, 255, 0.1); 
        backdrop-filter: blur(12px); 
        border: 1px solid rgba(255,255,255,0.1);
        padding: 8px 18px;
        border-radius: 100px;
        color: #e0e7ff;
        font-weight: 700;
        font-size: 0.85rem;
    }

    .fw-800 { font-weight: 800; }
    .max-w-600 { max-width: 600px; }

    .btn-action-glow {
        background: var(--indigo-primary);
        color: white;
        border: none;
        font-weight: 700;
        box-shadow: 0 0 20px rgba(99, 102, 241, 0.4);
        transition: 0.4s;
    }
    .btn-action-glow:hover {
        background: var(--indigo-dark);
        transform: translateY(-5px);
        box-shadow: 0 15px 30px rgba(99, 102, 241, 0.6);
        color: white;
    }

    /* Content Area */
    .content-shift-up { margin-top: -60px; position: relative; z-index: 20; padding: 0 5%; }

    /* Premium Request Card */
    .request-card-premium {
        background: var(--card-dark);
        border-radius: 30px;
        padding: 30px;
        border: 1px solid rgba(255,255,255,0.05);
        transition: 0.4s cubic-bezier(0.175, 0.885, 0.32, 1.275);
        height: 100%;
        display: flex;
        flex-direction: column;
        position: relative;
    }

    .request-card-premium:hover {
        transform: translateY(-12px) scale(1.02);
        border-color: var(--indigo-primary);
        box-shadow: 0 25px 50px -12px rgba(0, 0, 0, 0.5);
    }

    .card-status-pill { position: absolute; top: 25px; left: 25px; }
    .badge-status.status-new { background: rgba(59, 130, 246, 0.1); color: #3b82f6; border: 1px solid rgba(59, 130, 246, 0.2); }
    .badge-status.status-contacted { background: rgba(168, 85, 247, 0.1); color: #a855f7; border: 1px solid rgba(168, 85, 247, 0.2); }
    .badge-status.status-accepted { background: rgba(16, 185, 129, 0.1); color: #10b981; border: 1px solid rgba(16, 185, 129, 0.2); }
    .badge-status.status-rejected { background: rgba(239, 68, 68, 0.1); color: #ef4444; border: 1px solid rgba(239, 68, 68, 0.2); }

    .card-top-vibe { display: flex; align-items: center; gap: 15px; }
    .user-avatar-premium {
        width: 60px;
        height: 60px;
        background: linear-gradient(135deg, #3730a3 0%, #4338ca 100%);
        border-radius: 20px;
        display: flex;
        align-items: center;
        justify-content: center;
        position: relative;
    }
    .avatar-ring { position: absolute; inset: -4px; border: 2px solid var(--indigo-primary); border-radius: 24px; opacity: 0.3; }
    .avatar-initials { color: white; font-weight: 800; font-size: 1.4rem; font-family: 'Outfit'; }

    .interest-pill-lux {
        background: rgba(99, 102, 241, 0.08);
        padding: 10px 18px;
        border-radius: 16px;
        color: #a5b4fc;
        font-size: 0.85rem;
        font-weight: 700;
        text-align: center;
    }

    .quick-contact-grid { display: grid; gap: 10px; }
    .contact-item-lux {
        display: flex;
        align-items: center;
        gap: 12px;
        font-size: 0.8rem;
        color: var(--slate-400);
        background: rgba(0,0,0,0.2);
        padding: 10px 15px;
        border-radius: 14px;
        transition: 0.3s;
    }
    .contact-item-lux i { color: var(--indigo-primary); font-size: 1rem; }
    .request-card-premium:hover .contact-item-lux { background: rgba(255,255,255,0.03); }

    .btn-glass-dark { background: rgba(255,255,255,0.05); color: #f1f5f9; border: 1px solid rgba(255,255,255,0.1); border-radius: 14px; font-weight: 700; transition: 0.3s; }
    .btn-glass-dark:hover { background: rgba(255,255,255,0.1); color: white; transform: translateY(-3px); }

    .btn-primary-sleek { background: var(--indigo-primary); color: white; border: none; border-radius: 14px; font-weight: 700; transition: 0.3s; }
    .btn-primary-sleek:hover { background: var(--indigo-dark); box-shadow: 0 10px 20px rgba(79, 70, 229, 0.3); color: white; transform: translateY(-3px); }

    .btn-link-danger { color: #f87171; opacity: 0.7; transition: 0.3s; border-radius: 8px; }
    .btn-link-danger:hover { opacity: 1; background: rgba(248, 113, 113, 0.05); }

    /* Empty State LUX */
    .empty-state-card-lux { text-align: center; padding: 100px 30px; background: var(--card-dark); border-radius: 40px; border: 2px dashed rgba(255,255,255,0.05); }
    .empty-visual-wrapper { position: relative; width: 120px; height: 120px; margin: 0 auto; display: flex; align-items: center; justify-content: center; }
    .glow-pulse { position: absolute; inset: 0; background: var(--indigo-primary); opacity: 0.1; border-radius: 50%; animation: ping 3s infinite; }
    .empty-icon-vibe { font-size: 4rem; color: var(--indigo-primary); position: relative; z-index: 2; }

    /* Modals Dark LUX */
    .premium-modal-dark { background: var(--slate-900); border-radius: 35px; overflow: hidden; }
    .info-strip-premium { background: rgba(255,255,255,0.03); padding: 20px; border-radius: 20px; display: flex; align-items: center; gap: 15px; }
    .strip-avatar { width: 50px; height: 50px; border-radius: 15px; display: flex; align-items: center; justify-content: center; color: white; font-size: 1.2rem; }
    
    .detail-box-lux { background: rgba(0,0,0,0.2); padding: 25px; border-radius: 25px; border: 1px solid rgba(255,255,255,0.05); }
    .detail-label-sleek { font-size: 0.8rem; font-weight: 800; color: var(--indigo-primary); margin-bottom: 12px; display: block; }
    .detail-content-sleek { font-size: 0.95rem; color: #cbd5e1; line-height: 1.8; }

    .btn-glass-indigo { background: rgba(99, 102, 241, 0.1); color: var(--indigo-primary); border: 1px solid rgba(99, 102, 241, 0.2); transition: 0.3s; }
    .btn-glass-indigo:hover { background: var(--indigo-primary); color: white; }

    /* Add Logic Styling */
    .header-icon-box-lux { width: 48px; height: 48px; border-radius: 14px; display: flex; align-items: center; justify-content: center; color: white; font-size: 1.3rem; }
    .label-lux { color: #94a3b8; font-weight: 700; font-size: 0.85rem; margin-bottom: 10px; display: block; }
    .field-lux { width: 100%; background: #0b0e14; border: 2px solid #1e293b; border-radius: 16px; padding: 14px 20px; color: white; font-weight: 600; transition: 0.3s; }
    .field-lux:focus { border-color: var(--indigo-primary); outline: none; background: #000; box-shadow: 0 0 0 4px rgba(99, 102, 241, 0.1); }
    
    .upload-zone-lux { border: 2px dashed #1e293b; border-radius: 25px; height: 180px; position: relative; overflow: hidden; transition: 0.3s; cursor: pointer; }
    .upload-zone-lux:hover { border-color: var(--indigo-primary); background: rgba(99, 102, 241, 0.05); }
    .file-hidden { position: absolute; inset: 0; opacity: 0; cursor: pointer; z-index: 10; }
    .preview-area-lux { height: 100%; display: flex; align-items: center; justify-content: center; text-align: center; }

    .stats-row-lux { display: grid; grid-template-columns: repeat(4, 1fr); gap: 15px; }
    .btn-indigo-solid { background: var(--indigo-primary); color: white; border: none; transition: 0.3s; }
    .btn-indigo-solid:hover { background: var(--indigo-dark); transform: translateY(-3px); box-shadow: 0 15px 30px rgba(99, 102, 241, 0.3); }

    /* Animations */
    @keyframes ping { 75%, 100% { transform: scale(1.5); opacity: 0; } }
    .animate-reveal-right { animation: revealRight 1s both; }
    .animate-reveal-left { animation: revealLeft 1s both; }
    .animate-up { animation: fadeInUp 0.8s both; }

    @keyframes revealRight { from { opacity: 0; transform: translateX(50px); } to { opacity: 1; transform: translateX(0); } }
    @keyframes revealLeft { from { opacity: 0; transform: translateX(-50px); } to { opacity: 1; transform: translateX(0); } }
    @keyframes fadeInUp { from { opacity: 0; transform: translateY(30px); } to { opacity: 1; transform: translateY(0); } }

    .scroll-thin::-webkit-scrollbar { width: 5px; }
    .scroll-thin::-webkit-scrollbar-thumb { background: #334155; border-radius: 10px; }

    @media (max-width: 991px) {
        .premium-hero-sleek { border-radius: 0 0 30px 30px; padding: 60px 0 80px; }
        .display-4 { font-size: 2.2rem; }
        .stats-row-lux { grid-template-columns: 1fr; }
    }
</style>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\Users\HP\Downloads\ensan\System.Ensan-main\System.Ensan-main\resources\views/website/volunteer_requests.blade.php ENDPATH**/ ?>