<?php
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\DonorController;
use App\Http\Controllers\DonationController;
use App\Http\Controllers\BeneficiaryController;
use App\Http\Controllers\ProjectController;
use App\Http\Controllers\CampaignController;
use App\Http\Controllers\WarehouseController;
use App\Http\Controllers\ItemController;
use App\Http\Controllers\InventoryTransactionController;
use App\Http\Controllers\TaskController;
use App\Http\Controllers\AccountController;
use App\Http\Controllers\JournalEntryController;
use App\Http\Controllers\ComplaintController;
use App\Http\Controllers\RoleController;
use App\Http\Controllers\UserController;
use App\Http\Controllers\AuthController;
use App\Http\Controllers\DelegateController;
use App\Http\Controllers\TravelRouteController;
use App\Http\Controllers\ExpenseController;
use App\Http\Controllers\FinancialClosureController;
use App\Http\Controllers\VolunteerHourController;
use App\Http\Controllers\PayrollController;
use App\Http\Controllers\AttachmentController;
use App\Http\Controllers\Api\WebsiteApiController;
use App\Http\Controllers\Api\WebsiteContentController;

Route::prefix('v1')->group(function () {
    Route::get('/', function () {
            return response()->json(['status' => 'ok']);
        }
        );

        Route::post('auth/register', [AuthController::class , 'register']);
        Route::post('auth/login', [AuthController::class , 'login']);
        Route::post('auth/logout', [AuthController::class , 'logout'])->middleware(\App\Http\Middleware\TokenAuth::class);

        // Authenticated Routes
        Route::middleware([\App\Http\Middleware\TokenAuth::class , \App\Http\Middleware\RoleAccess::class , \App\Http\Middleware\AuditLogger::class])->group(function () {
            Route::apiResource('donors', DonorController::class);
            Route::apiResource('donations', DonationController::class);
            Route::apiResource('beneficiaries', BeneficiaryController::class);
            Route::apiResource('projects', ProjectController::class);
            Route::apiResource('campaigns', CampaignController::class);
            Route::apiResource('warehouses', WarehouseController::class);
            Route::apiResource('items', ItemController::class);
            Route::apiResource('inventory-transactions', InventoryTransactionController::class);
            Route::apiResource('tasks', TaskController::class);
            Route::apiResource('accounts', AccountController::class);
            Route::apiResource('journal-entries', JournalEntryController::class);
            Route::apiResource('complaints', ComplaintController::class);
            Route::apiResource('roles', RoleController::class);
            Route::apiResource('users', UserController::class);
            Route::apiResource('delegates', DelegateController::class);
            Route::apiResource('travel-routes', TravelRouteController::class);
            Route::apiResource('expenses', ExpenseController::class);
            Route::apiResource('volunteer-hours', VolunteerHourController::class);
            Route::apiResource('payrolls', PayrollController::class);
            Route::get('finance/closures', [FinancialClosureController::class , 'index']);
            Route::post('finance/close', [FinancialClosureController::class , 'store']);
            Route::post('finance/closures/{closure}/approve', [FinancialClosureController::class , 'approve']);
            Route::post('users/{user}/roles/{role}', [UserController::class , 'attachRole'])->name('users.attachRole');
            Route::delete('users/{user}/roles/{role}', [UserController::class , 'detachRole'])->name('users.detachRole');
            Route::get('reports/donors', [\App\Http\Controllers\ReportsController::class , 'donors'])->name('reports.donors');
            Route::get('reports/donations', [\App\Http\Controllers\ReportsController::class , 'donations'])->name('reports.donations');
            Route::get('reports/inventory', [\App\Http\Controllers\ReportsController::class , 'inventory'])->name('reports.inventory');
            Route::get('reports/beneficiaries', [\App\Http\Controllers\ReportsController::class , 'beneficiaries'])->name('reports.beneficiaries');
            Route::get('reports/finance', [\App\Http\Controllers\ReportsController::class , 'finance'])->name('reports.finance');
            Route::post('attachments', [AttachmentController::class , 'store']);
            Route::delete('attachments/{attachment}', [AttachmentController::class , 'destroy']);

            // --- Website Management (Admin) ---
            Route::prefix('admin/website')->group(function () {
                    Route::get('/settings', [WebsiteApiController::class , 'getSettings']);
                    Route::post('/settings', [WebsiteApiController::class , 'updateSettings']);

                    Route::get('/projects', [WebsiteApiController::class , 'projects']);
                    Route::post('/projects/{project}', [WebsiteApiController::class , 'updateProjectWebsite']);

                    Route::get('/campaigns', [WebsiteApiController::class , 'campaigns']);
                    Route::post('/campaigns/{campaign}', [WebsiteApiController::class , 'updateCampaignWebsite']);

                    // Section CRUD
                    Route::get('/board-members', [WebsiteApiController::class , 'boardMembers']);
                    Route::post('/board-members', [WebsiteApiController::class , 'storeBoardMember']);
                    Route::post('/board-members/{member}', [WebsiteApiController::class , 'updateBoardMember']);
                    Route::delete('/board-members/{member}', [WebsiteApiController::class , 'destroyBoardMember']);

                    Route::get('/testimonials', [WebsiteApiController::class , 'getTestimonials']);
                    Route::post('/testimonials', [WebsiteApiController::class , 'storeTestimonial']);
                    Route::post('/testimonials/{testimonial}', [WebsiteApiController::class , 'updateTestimonial']);
                    Route::delete('/testimonials/{testimonial}', [WebsiteApiController::class , 'destroyTestimonial']);

                    Route::get('/features', [WebsiteApiController::class , 'getFeatures']);
                    Route::post('/features', [WebsiteApiController::class , 'storeFeature']);
                    Route::post('/features/{feature}', [WebsiteApiController::class , 'updateFeature']);
                    Route::delete('/features/{feature}', [WebsiteApiController::class , 'destroyFeature']);

                    Route::get('/sectors', [WebsiteApiController::class , 'getSectors']);
                    Route::post('/sectors', [WebsiteApiController::class , 'storeSector']);
                    Route::post('/sectors/{sector}', [WebsiteApiController::class , 'updateSector']);
                    Route::delete('/sectors/{sector}', [WebsiteApiController::class , 'destroySector']);

                    Route::get('/branches', [WebsiteApiController::class , 'getBranches']);
                    Route::post('/branches', [WebsiteApiController::class , 'storeBranch']);
                    Route::post('/branches/{branch}', [WebsiteApiController::class , 'updateBranch']);
                    Route::delete('/branches/{branch}', [WebsiteApiController::class , 'destroyBranch']);

                    Route::get('/volunteer-wall', [WebsiteApiController::class , 'getVolunteerWall']);
                    Route::post('/volunteer-wall', [WebsiteApiController::class , 'storeVolunteerWall']);
                    Route::post('/volunteer-wall/{item}', [WebsiteApiController::class , 'updateVolunteerWall']);
                    Route::delete('/volunteer-wall/{item}', [WebsiteApiController::class , 'destroyVolunteerWall']);

                    Route::get('/partners', [WebsiteApiController::class , 'partners']);
                    Route::post('/partners', [WebsiteApiController::class , 'storePartner']);
                    Route::post('/partners/{partner}', [WebsiteApiController::class , 'updatePartner']);
                    Route::delete('/partners/{partner}', [WebsiteApiController::class , 'destroyPartner']);

                    Route::get('/news', [WebsiteApiController::class , 'news']);
                    Route::post('/news', [WebsiteApiController::class , 'storeNews']);
                    Route::post('/news/{news}', [WebsiteApiController::class , 'updateNews']);
                    Route::delete('/news/{news}', [WebsiteApiController::class , 'destroyNews']);

                    Route::get('/events', [WebsiteApiController::class , 'adminEvents']);
                    Route::post('/events', [WebsiteApiController::class , 'storeEvent']);
                    Route::post('/events/{event}', [WebsiteApiController::class , 'updateEvent']);
                    Route::delete('/events/{event}', [WebsiteApiController::class , 'destroyEvent']);

                    Route::get('/faqs', [WebsiteApiController::class , 'getFaqs']);
                    Route::post('/faqs', [WebsiteApiController::class , 'storeFaq']);
                    Route::post('/faqs/{faq}', [WebsiteApiController::class , 'updateFaq']);
                    Route::delete('/faqs/{faq}', [WebsiteApiController::class , 'destroyFaq']);

                    // Operations
                    Route::get('/contact-messages', [WebsiteApiController::class , 'getContactMessages']);
                    Route::patch('/contact-messages/{message}/read', [WebsiteApiController::class , 'markContactMessageRead']);
                    Route::delete('/contact-messages/{message}', [WebsiteApiController::class , 'destroyContactMessage']);

                    Route::get('/volunteer-requests', [WebsiteApiController::class , 'getVolunteerRequests']);
                    Route::delete('/volunteer-requests/{request}', [WebsiteApiController::class , 'destroyVolunteerRequest']);

                    Route::get('/room-bookings', [WebsiteApiController::class , 'getRoomBookings']);
                    Route::patch('/room-bookings/{booking}/status', [WebsiteApiController::class , 'updateRoomBookingStatus']);
                    Route::delete('/room-bookings/{booking}', [WebsiteApiController::class , 'destroyRoomBooking']);

                    // Website Content Management (Projects, Campaigns, Pages)
                    Route::controller(WebsiteContentController::class)->prefix('content')->group(function () {
                            Route::get('/projects', 'indexProjects');
                            Route::post('/projects', 'storeProject');
                            Route::get('/projects/{project}', 'showProject');
                            Route::post('/projects/{project}', 'updateProject');
                            Route::delete('/projects/{project}', 'destroyProject');

                            Route::get('/campaigns', 'indexCampaigns');
                            Route::post('/campaigns', 'storeCampaign');
                            Route::get('/campaigns/{campaign}', 'showCampaign');
                            Route::post('/campaigns/{campaign}', 'updateCampaign');
                            Route::delete('/campaigns/{campaign}', 'destroyCampaign');

                            Route::get('/pages', 'indexPages');
                            Route::post('/pages', 'storePage');
                            Route::get('/pages/{page}', 'showPage');
                            Route::post('/pages/{page}', 'updatePage');
                            Route::delete('/pages/{page}', 'destroyPage');
                        }
                        );
                    }
                    );
                }
                );

                // --- Public Website APIs ---
                Route::prefix('website')->group(function () {
            Route::get('/', [WebsiteApiController::class , 'landingPage']);
            Route::get('/landing', [WebsiteApiController::class , 'landingPage']);
            Route::get('/projects', [WebsiteApiController::class , 'projects']);
            Route::get('/projects/{project}', [WebsiteApiController::class , 'projectShow']);
            Route::get('/campaigns', [WebsiteApiController::class , 'campaigns']);
            Route::get('/campaigns/{campaign}', [WebsiteApiController::class , 'campaignShow']);
            Route::get('/news', [WebsiteApiController::class , 'news']);
            Route::get('/news/{news}', [WebsiteApiController::class , 'newsShow']);
            Route::get('/events', [WebsiteApiController::class , 'events']);
            Route::get('/events/{event}', [WebsiteApiController::class , 'eventShow']);
            Route::get('/faqs', [WebsiteApiController::class , 'getFaqs']);
            Route::get('/volunteer', [WebsiteApiController::class , 'volunteerPage']);
            Route::get('/contact', [WebsiteApiController::class , 'contactPage']);
            Route::get('/guest-house', [WebsiteApiController::class , 'guestHousePage']);
            Route::get('/stats', [WebsiteApiController::class , 'getStats']);
            Route::post('/opinions', [WebsiteApiController::class, 'submitOpinion']);
            Route::get('/opinions', [WebsiteApiController::class, 'getOpinions']);
            Route::get('/notification', [WebsiteApiController::class , 'breakingNews']);
            Route::get('/features', [WebsiteApiController::class , 'features']);
            Route::get('/sectors', [WebsiteApiController::class , 'sectors']);
            Route::get('/branches', [WebsiteApiController::class , 'branches']);
            Route::get('/coverage', [WebsiteApiController::class , 'coverage']);

            // Form submissions (POST submit)
            Route::post('/volunteer', [WebsiteApiController::class , 'submitVolunteer']);

            Route::post('/contact', [WebsiteApiController::class , 'submitContact']);

            Route::get('/room-booking', [WebsiteApiController::class , 'roomBookingInfo']);
            Route::post('/room-booking', [WebsiteApiController::class , 'submitRoomBooking']);

            Route::post('/guest-house', [WebsiteApiController::class , 'submitRoomBooking']); // Alias
            Route::get('/testimonials', [WebsiteApiController::class , 'testimonials']);
            Route::post('/testimonials', [WebsiteApiController::class , 'submitTestimonial']);

            // Dynamic Pages API
            Route::get('/pages', [\App\Http\Controllers\WebsiteWebController::class , 'apiGetPages']);
            Route::get('/pages/{slug}', [\App\Http\Controllers\WebsiteWebController::class , 'apiGetPage']);

            // Volunteer Wall & Partners Public API
            Route::get('/volunteer-wall', [WebsiteContentController::class , 'getVolunteerWall']);
            Route::get('/partners', [WebsiteContentController::class , 'getPartners']);
            Route::get('/board-members', [WebsiteApiController::class , 'boardMembers']);
        }
        );
    });
