@extends('layouts.app')

@section('content')
<link href="https://fonts.googleapis.com/css2?family=Outfit:wght@300;400;600;700&family=Tajawal:wght@300;400;500;700;800&display=swap" rel="stylesheet">

<div class="bookings-page">
    <div class="premium-hero-sleek">
        <div class="hero-bg-visuals">
            <div class="glow-orb-1" style="background: #1e3a8a;"></div>
            <div class="glow-orb-2" style="background: #3b82f6;"></div>
            <div class="noise-overlay"></div>
        </div>
        <div class="hero-content-wrapper container-fluid">
            <div class="row align-items-center">
                <div class="col-lg-8 animate-reveal-right text-end">
                    <nav aria-label="breadcrumb" class="mb-4 d-flex justify-content-end">
                        <ol class="breadcrumb mb-0">
                            <li class="breadcrumb-item"><a href="{{ route('dashboard.index') }}" class="text-white-50 decoration-none">لوحة التحكم</a></li>
                            <li class="breadcrumb-item active text-white" aria-current="page">طلبات الحجز</li>
                        </ol>
                    </nav>
                    <div class="d-flex align-items-center justify-content-end gap-3 mb-3">
                        <div class="badge-glass-premium">
                            <i class="bi bi-house-heart-fill me-2"></i> إدارة حجوزات دار الضيافة
                        </div>
                    </div>
                    <h1 class="display-4 fw-800 text-white mb-3 text-end">طلبات الحجز من الويب</h1>
                    <p class="lead text-white-50 mb-0 max-w-600 ms-auto me-0 text-end">
                        مراجعة والرد على طلبات حجز الغرف الواردة عبر الموقع الإلكتروني
                    </p>
                </div>
                <div class="col-lg-4 text-start mt-4 mt-lg-0 animate-reveal-left"></div>
            </div>
        </div>
    </div>

<div class="container-fluid py-4">
    <div class="row g-4">
        <div class="col-12">
            <div class="glass-card overflow-hidden">
                <div class="table-responsive">
                    <table class="table table-hover align-middle mb-0">
                        <thead class="bg-light">
                            <tr>
                                <th class="ps-4">صاحب الطلب</th>
                                <th>تاريخ الوصول / المغادرة</th>
                                <th>الغرفة / الدار</th>
                                <th>الحالة</th>
                                <th class="text-center">الإجراء</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($bookings as $booking)
                            <tr>
                                <td class="ps-4">
                                    <div class="fw-bold">{{ $booking->name }}</div>
                                    <div class="x-small text-muted">{{ $booking->phone }} | {{ $booking->email }}</div>
                                </td>
                                <td>
                                    <div class="small fw-bold">{{ $booking->check_in }} <i class="bi bi-arrow-left text-muted px-1"></i> {{ $booking->check_out }}</div>
                                    <div class="x-small text-info">{{ \Carbon\Carbon::parse($booking->check_in)->diffInDays($booking->check_out) }} ليالي</div>
                                </td>
                                <td>
                                    <div class="small fw-bold">{{ $booking->guestHouse->name ?? 'غير محدد' }}</div>
                                    <span class="badge bg-secondary-subtle text-secondary x-small">{{ $booking->room_type }}</span>
                                </td>
                                <td>
                                    @php
                                        $statusClass = [
                                            'pending' => 'bg-warning-subtle text-warning border-warning-subtle',
                                            'confirmed' => 'bg-success-subtle text-success border-success-subtle',
                                            'cancelled' => 'bg-danger-subtle text-danger border-danger-subtle'
                                        ][$booking->status] ?? 'bg-light';
                                        
                                        $statusText = [
                                            'pending' => 'قيد الانتظار',
                                            'confirmed' => 'مؤكد',
                                            'cancelled' => 'ملغي'
                                        ][$booking->status] ?? $booking->status;
                                    @endphp
                                    <span class="badge {{ $statusClass }} border px-3 rounded-pill">{{ $statusText }}</span>
                                </td>
                                <td class="text-center">
                                    <div class="d-flex justify-content-center gap-2">
                                        <button class="btn btn-sm btn-light border rounded-pill px-3 shadow-none" data-bs-toggle="modal" data-bs-target="#viewBooking{{ $booking->id }}">
                                            <i class="bi bi-eye me-1"></i> تفاصيل
                                        </button>
                                        <div class="dropdown">
                                            <button class="btn btn-sm btn-light border rounded-pill px-3 dropdown-toggle shadow-none" data-bs-toggle="dropdown">
                                                تغيير الحالة
                                            </button>
                                            <ul class="dropdown-menu dropdown-menu-end shadow-sm border-0 glass-dropdown">
                                                <li>
                                                    <form action="{{ route('website.bookings.update', $booking) }}" method="POST">
                                                        @csrf @method('PATCH')
                                                        <input type="hidden" name="status" value="confirmed">
                                                        <button type="submit" class="dropdown-item py-2 small"><i class="bi bi-check-circle me-2 text-success"></i> تأكيد الحجز</button>
                                                    </form>
                                                </li>
                                                <li>
                                                    <form action="{{ route('website.bookings.update', $booking) }}" method="POST">
                                                        @csrf @method('PATCH')
                                                        <input type="hidden" name="status" value="cancelled">
                                                        <button type="submit" class="dropdown-item py-2 small"><i class="bi bi-x-circle me-2 text-danger"></i> إلغاء الحجز</button>
                                                    </form>
                                                </li>
                                            </ul>
                                        </div>
                                    </div>
                                </td>
                            </tr>

                            {{-- Booking Details Modal --}}
                            <div class="modal fade" id="viewBooking{{ $booking->id }}" tabindex="-1" aria-hidden="true">
                                <div class="modal-dialog modal-lg modal-dialog-centered">
                                    <div class="modal-content border-0 shadow-lg rounded-4 overflow-hidden">
                                        <div class="modal-header border-0 bg-light-subtle px-4 py-3">
                                            <h5 class="modal-title fw-bold">تفاصيل طلب الحجز #{{ $booking->id }}</h5>
                                            <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                                        </div>
                                        <div class="modal-body p-0">
                                            <div class="row g-0">
                                                {{-- Sidebar Info --}}
                                                <div class="col-md-4 bg-light bg-opacity-50 border-end p-4">
                                                    <div class="text-center mb-4">
                                                        <div class="avatar-placeholder bg-white shadow-sm rounded-circle d-flex align-items-center justify-content-center mx-auto mb-3" style="width: 80px; height: 80px;">
                                                            <i class="bi bi-person-badge fs-1 text-primary-subtle"></i>
                                                        </div>
                                                        <h6 class="fw-bold mb-1">{{ $booking->name }}</h6>
                                                        <div class="x-small text-muted">{{ $booking->phone }}</div>
                                                        <div class="x-small text-muted">{{ $booking->email }}</div>
                                                    </div>

                                                    <div class="vstack gap-3">
                                                        <div class="p-3 bg-white rounded-3 border shadow-sm">
                                                            <div class="x-small text-uppercase text-muted fw-bold mb-2">المرافق</div>
                                                            <div class="fw-medium text-dark">{{ $booking->companion_name ?? 'لا يوجد' }}</div>
                                                            @if($booking->companion_phone)
                                                                <div class="x-small text-muted mt-1"><i class="bi bi-telephone me-1"></i> {{ $booking->companion_phone }}</div>
                                                            @endif
                                                        </div>

                                                        <div class="p-3 bg-white rounded-3 border shadow-sm">
                                                            <div class="x-small text-uppercase text-muted fw-bold mb-2">مكان الإقامة</div>
                                                            <div class="d-flex align-items-start gap-2">
                                                                <i class="bi bi-geo-alt text-danger mt-1"></i>
                                                                <div>
                                                                    <div class="fw-medium text-dark">{{ $booking->address ?? 'غير محدد' }}</div>
                                                                    @if($booking->national_id)
                                                                        <div class="x-small text-muted mt-1">بطاقة: {{ $booking->national_id }}</div>
                                                                    @endif
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>

                                                {{-- Main Details --}}
                                                <div class="col-md-8 p-4">
                                                    <h6 class="fw-bold border-bottom pb-2 mb-3 text-primary"><i class="bi bi-hospital me-2"></i> تفاصيل العلاج والإقامة</h6>
                                                    <div class="row g-3 mb-4">
                                                        <div class="col-md-6">
                                                            <label class="x-small text-muted fw-bold">المركز الطبي / المستشفى</label>
                                                            <div class="fw-medium">{{ $booking->medical_center ?? '-' }}</div>
                                                        </div>
                                                        <div class="col-md-6">
                                                            <label class="x-small text-muted fw-bold">مدة الإقامة المتوقعة</label>
                                                            <div class="fw-medium">{{ $booking->expected_duration_arabic ?? '-' }}</div>
                                                        </div>
                                                        <div class="col-md-6">
                                                            <label class="x-small text-muted fw-bold">تاريخ الوصول</label>
                                                            <div class="fw-medium">{{ $booking->arrival_date ?? $booking->check_in }}</div>
                                                        </div>
                                                        <div class="col-md-6">
                                                            <label class="x-small text-muted fw-bold">نوع الغرفة</label>
                                                            <div class="fw-medium">{{ $booking->room_type }}</div>
                                                        </div>
                                                    </div>

                                                    <h6 class="fw-bold border-bottom pb-2 mb-3 text-primary"><i class="bi bi-paperclip me-2"></i> المستندات المرفقة</h6>
                                                    <div class="row g-2 mb-4">
                                                        @php
                                                            $docs = [
                                                                ['label' => 'بطاقة المريض', 'path' => $booking->patient_id_path],
                                                                ['label' => 'بطاقة المرافق', 'path' => $booking->companion_id_path],
                                                                ['label' => 'تحويل المستشفى', 'path' => $booking->medical_transfer_path],
                                                                ['label' => 'كارت المتابعة', 'path' => $booking->followup_card_path],
                                                                ['label' => 'تقرير الإشعاع', 'path' => $booking->medical_report_path],
                                                            ];
                                                        @endphp

                                                        @foreach($docs as $doc)
                                                            @if($doc['path'])
                                                                <div class="col-auto">
                                                                    <a href="{{ asset('storage/' . $doc['path']) }}" target="_blank" class="btn btn-sm btn-outline-secondary d-flex align-items-center gap-2">
                                                                        <i class="bi bi-file-earmark-image"></i> {{ $doc['label'] }}
                                                                    </a>
                                                                </div>
                                                            @endif
                                                        @endforeach

                                                        @if(collect($docs)->where('path', '!=', null)->isEmpty())
                                                            <div class="col-12 text-muted x-small fst-italic">لا توجد مستندات مرفقة</div>
                                                        @endif
                                                    </div>

                                                    @if($booking->notes)
                                                        <h6 class="fw-bold border-bottom pb-2 mb-2 text-primary"><i class="bi bi-pencil me-2"></i> ملاحظات إضافية</h6>
                                                        <div class="p-3 bg-light rounded border border-light-subtle text-muted small">
                                                            {{ $booking->notes }}
                                                        </div>
                                                    @endif
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            @endforeach
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>

<style>
    body { background-color: #0b0e14 !important; }
    .bookings-page { min-height: 100vh; }

    /* Premium Hero */
    .premium-hero-sleek { position: relative; padding: 100px 0 120px; background: linear-gradient(135deg, #1e3a8a 0%, #3b82f6 100%); border-radius: 0 0 60px 60px; overflow: hidden; z-index: 10; box-shadow: 0 20px 50px rgba(0,0,0,0.3); }
    .hero-bg-visuals div { position: absolute; border-radius: 50%; filter: blur(100px); opacity: 0.4; pointer-events: none; }
    .glow-orb-1 { width: 400px; height: 400px; top: -100px; right: -50px; }
    .glow-orb-2 { width: 300px; height: 300px; bottom: -150px; left: -50px; }
    .noise-overlay { position: absolute; inset: 0; opacity: 0.05; }
    .hero-content-wrapper { position: relative; z-index: 5; padding: 0 5%; }
    .badge-glass-premium { background: rgba(255,255,255,0.1); backdrop-filter: blur(12px); border: 1px solid rgba(255,255,255,0.1); padding: 8px 18px; border-radius: 100px; color: #93c5fd; font-weight: 700; font-size: 0.85rem; }
    .fw-800 { font-weight: 800; }
    .max-w-600 { max-width: 600px; }
    .animate-reveal-right { animation: revealRight 1s both; }
    .animate-reveal-left { animation: revealLeft 1s both; }
    @keyframes revealRight { from { opacity: 0; transform: translateX(50px); } to { opacity: 1; transform: translateX(0); } }
    @keyframes revealLeft { from { opacity: 0; transform: translateX(-50px); } to { opacity: 1; transform: translateX(0); } }
    @media (max-width: 991px) { .premium-hero-sleek { border-radius: 0 0 30px 30px; padding: 60px 0 80px; } .display-4 { font-size: 2.2rem; } }

    .glass-card { background: white; border-radius: 20px; box-shadow: 0 10px 30px rgba(0,0,0,0.04); border: 1px solid #f1f5f9; }
    .glass-dropdown { backdrop-filter: blur(10px); background: rgba(255,255,255,0.9); border-radius: 12px; }
    .x-small { font-size: 0.7rem; }
</style>
@endsection
