@extends('layouts.app')

@section('content')
<div class="dashboard-hero animate-slide-up" style="background: linear-gradient(135deg, #be123c 0%, #e11d48 100%);">
    <div class="hero-content">
        <div class="hero-greeting text-white-50">طلبات المساعدة 🆘</div>
        <h1 class="hero-title">الحالات الإنسانية (Cases)</h1>
        <p class="hero-subtitle">استقبال ومراجعة طلبات الدعم الواردة عبر التطبيق</p>
    </div>
</div>

<div class="container-fluid py-4">
    <div class="row g-4">
        <div class="col-12">
            <div class="glass-card overflow-hidden animate-slide-up">
                 <div class="d-flex justify-content-between align-items-center p-4 border-bottom bg-light bg-opacity-50">
                    <h5 class="fw-bold mb-0 text-danger"><i class="bi bi-heart-pulse me-2"></i> الطلبات الجديدة</h5>
                    <span class="badge bg-danger rounded-pill px-3">{{ $applications->where('status', 'pending')->count() }} طلب معلق</span>
                </div>
                
                <div class="table-responsive">
                    <table class="table table-hover align-middle mb-0">
                        <thead class="bg-white text-muted small fw-bold text-uppercase border-bottom">
                            <tr>
                                <th class="ps-4">مقدم الطلب</th>
                                <th>نوع الحالة</th>
                                <th>الموقع</th>
                                <th>الحالة</th>
                                <th>تاريخ التقديم</th>
                                <th class="text-center">الإجراء</th>
                            </tr>
                        </thead>
                        <tbody>
                            @forelse($applications as $case)
                            <tr class="case-row {{ $case->status == 'pending' ? 'bg-danger-subtle bg-opacity-10' : '' }}">
                                <td class="ps-4">
                                    <div class="fw-bold text-dark">{{ $case->applicant_name }}</div>
                                    <div class="x-small text-muted font-monospace">{{ $case->applicant_phone }}</div>
                                </td>
                                <td><span class="badge bg-light text-dark border fw-normal">{{ $case->case_type }}</span></td>
                                <td class="small">{{ $case->governorate }} - {{ $case->city }}</td>
                                <td>
                                    @php
                                        $badges = [
                                            'pending' => 'bg-warning text-dark',
                                            'approved' => 'bg-success text-white',
                                            'rejected' => 'bg-danger text-white',
                                            'reviewing' => 'bg-info text-white'
                                        ];
                                        $labels = [
                                            'pending' => 'قيد الانتظار',
                                            'approved' => 'تمت الموافقة',
                                            'rejected' => 'مرفوض',
                                            'reviewing' => 'قيد المراجعة'
                                        ];
                                    @endphp
                                    <span class="badge {{ $badges[$case->status] ?? 'bg-secondary' }} rounded-pill px-3 py-1 fw-normal">{{ $labels[$case->status] ?? $case->status }}</span>
                                </td>
                                <td class="small text-muted">{{ $case->created_at->format('Y-m-d') }}</td>
                                <td class="text-center">
                                    <button class="btn btn-sm btn-outline-danger rounded-pill px-3 fw-bold" data-bs-toggle="modal" data-bs-target="#viewCase{{ $case->id }}">
                                        التفاصيل <i class="bi bi-file-earmark-medical ms-1"></i>
                                    </button>
                                </td>
                            </tr>

                            {{-- Case Detail Modal --}}
                            <div class="modal fade" id="viewCase{{ $case->id }}" tabindex="-1">
                                <div class="modal-dialog modal-lg">
                                    <div class="modal-content glass-card border-0">
                                        <div class="modal-header border-0 bg-danger text-white">
                                            <h5 class="modal-title fw-bold">تفاصيل الحالة #{{ $case->id }}</h5>
                                            <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"></button>
                                        </div>
                                        <div class="modal-body p-4 bg-light bg-opacity-25">
                                            <div class="row g-4">
                                                <div class="col-md-6">
                                                    <h6 class="fw-bold text-dark border-bottom pb-2 mb-3">بيانات مقدم الطلب</h6>
                                                    <p class="mb-1 small text-muted">الاسم الكامل:</p>
                                                    <p class="fw-bold">{{ $case->applicant_name }}</p>
                                                    
                                                    <p class="mb-1 small text-muted">رقم الهوية:</p>
                                                    <p class="fw-bold font-monospace">{{ $case->applicant_id_number ?? 'غير متوفر' }}</p>
                                                    
                                                    <p class="mb-1 small text-muted">رقم الهاتف:</p>
                                                    <p class="fw-bold font-monospace text-primary"><a href="tel:{{ $case->applicant_phone }}" class="text-decoration-none">{{ $case->applicant_phone }}</a></p>
                                                </div>
                                                <div class="col-md-6">
                                                    <h6 class="fw-bold text-dark border-bottom pb-2 mb-3">تفاصيل الحالة</h6>
                                                    <p class="mb-1 small text-muted">نوع الاحتياج:</p>
                                                    <p class="badge bg-danger bg-opacity-10 text-danger border border-danger border-opacity-25 px-3">{{ $case->case_type }}</p>
                                                    
                                                    <p class="mb-1 small text-muted">العنوان:</p>
                                                    <p class="small">{{ $case->governorate }}، {{ $case->city }}<br>{{ $case->address }}</p>
                                                </div>
                                                <div class="col-12">
                                                    <div class="bg-white p-3 rounded border shadow-sm">
                                                        <p class="mb-1 x-small text-uppercase text-muted fw-bold ls-1">وصف الحالة</p>
                                                        <p class="mb-0 text-dark lh-base">{{ $case->description }}</p>
                                                    </div>
                                                </div>
                                                <div class="col-12">
                                                     <h6 class="fw-bold text-dark border-bottom pb-2 mb-3">المرفقات</h6>
                                                     <div class="d-flex gap-2">
                                                         @if($case->id_image_path)
                                                            <a href="{{ asset('storage/' . $case->id_image_path) }}" target="_blank" class="btn btn-sm btn-light border"><i class="bi bi-card-image me-1"></i> صورة الهوية</a>
                                                         @endif
                                                         @if($case->medical_report_path)
                                                            <a href="{{ asset('storage/' . $case->medical_report_path) }}" target="_blank" class="btn btn-sm btn-light border"><i class="bi bi-file-medical me-1"></i> التقرير الطبي</a>
                                                         @endif
                                                     </div>
                                                </div>
                                            </div>
                                            
                                            <hr class="my-4">
                                            
                                            <form action="{{ route('mobile.cases.update', $case) }}" method="POST">
                                                @csrf @method('PATCH')
                                                <div class="mb-3">
                                                    <label class="form-label small fw-bold">ملاحظات الإدارة (للمراجعة الداخلية)</label>
                                                    <textarea name="admin_notes" class="form-control" rows="2">{{ $case->admin_notes }}</textarea>
                                                </div>
                                                <div class="d-flex justify-content-end gap-2">
                                                    <input type="hidden" name="status" id="statusInput{{ $case->id }}">
                                                    <button type="submit" onclick="document.getElementById('statusInput{{ $case->id }}').value='rejected'" class="btn btn-outline-danger rounded-pill px-4">رفض الطلب</button>
                                                    <button type="submit" onclick="document.getElementById('statusInput{{ $case->id }}').value='reviewing'" class="btn btn-outline-info rounded-pill px-4">قيد المراجعة</button>
                                                    <button type="submit" onclick="document.getElementById('statusInput{{ $case->id }}').value='approved'" class="btn btn-success fw-bold rounded-pill px-4 text-white">قبول الحالة <i class="bi bi-check-lg ms-1"></i></button>
                                                </div>
                                            </form>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            @empty
                            <tr>
                                <td colspan="6" class="text-center py-5 text-muted">
                                    <div class="d-flex flex-column align-items-center">
                                        <i class="bi bi-inbox fs-1 opacity-25 mb-2"></i>
                                        <p class="mb-0">لا توجد طلبات جديدة حالياً</p>
                                    </div>
                                </td>
                            </tr>
                            @endforelse
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>

<style>
    .glass-card { background: white; border-radius: 16px; box-shadow: 0 4px 24px rgba(0,0,0,0.06); border: 1px solid #fff1f2; }
    .x-small { font-size: 0.7rem; }
    .ls-1 { letter-spacing: 1px; }
    .case-row:hover { background-color: #fff1f2 !important; }
</style>
@endsection
