<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class WebRoomBooking extends Model
{
    protected $fillable = [
        'name',
        'phone',
        'email',
        'guest_house_id',
        'room_type',
        'check_in',
        'check_out',
        'notes',
        'status',
        'national_id',
        'address',
        'companion_name',
        'companion_phone',
        'arrival_date',
        'expected_duration',
        'medical_center',
        'patient_id_path',
        'companion_id_path',
        'medical_transfer_path',
        'followup_card_path',
        'medical_report_path'
    ];

    public function guestHouse()
    {
        return $this->belongsTo(GuestHouse::class);
    }

    public function getExpectedDurationArabicAttribute()
    {
        $durations = [
            'less_than_week' => 'أقل من أسبوع',
            'one_week'      => 'أسبوع',
            'two_weeks'     => 'أسبوعين',
            'three_weeks'   => 'ثلاثة أسابيع',
            'month'         => 'شهر',
            'more_than_month' => 'أكثر من شهر',
        ];

        return $durations[$this->expected_duration] ?? $this->expected_duration;
    }
}
